/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class StructureShape
extends Shape
implements ToSmithyBuilder<StructureShape> {
    private final Map<String, MemberShape> members;

    private StructureShape(Builder builder) {
        super(builder, false);
        assert (builder.members != null);
        this.members = Collections.unmodifiableMap(new LinkedHashMap(builder.members));
        this.members.forEach((key, value) -> {
            ShapeId expected = this.getId().withMember((String)key);
            if (!value.getId().equals(expected)) {
                throw new IllegalArgumentException(String.format("Expected the `%s` member of `%s` to have an ID of `%s` but found `%s`", key, this.getId(), expected, value.getId()));
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)StructureShape.builder().from(this)).members(this.getAllMembers().values());
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.structureShape(this);
    }

    @Override
    public Optional<StructureShape> asStructureShape() {
        return Optional.of(this);
    }

    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    public List<String> getMemberNames() {
        return new ArrayList<String>(this.members.keySet());
    }

    public Optional<MemberShape> getMember(String name) {
        return Optional.ofNullable(this.members.get(name));
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.members.equals(((StructureShape)other).members);
    }

    public static final class Builder
    extends AbstractShapeBuilder<Builder, StructureShape> {
        private Map<String, MemberShape> members = new LinkedHashMap<String, MemberShape>();

        public StructureShape build() {
            return new StructureShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.STRUCTURE;
        }

        public Builder members(Collection<MemberShape> structureMembers) {
            this.members.clear();
            Objects.requireNonNull(structureMembers).forEach(this::addMember);
            return this;
        }

        public Builder clearMembers() {
            this.members.clear();
            return this;
        }

        @Override
        public Builder addMember(MemberShape member) {
            this.members.put(member.getMemberName(), member);
            return this;
        }

        public Builder removeMember(String member) {
            this.members.remove(member);
            return this;
        }
    }
}

