/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;

final class EachSelector
implements Selector {
    private final List<Selector> selectors;

    private EachSelector(List<Selector> predicates) {
        this.selectors = predicates;
    }

    static Selector of(List<Selector> predicates) {
        return predicates.size() == 1 ? predicates.get(0) : new EachSelector(predicates);
    }

    @Override
    public Set<Shape> select(NeighborProvider neighborProvider, Set<Shape> shapes) {
        return this.selectors.stream().flatMap(selector -> selector.select(neighborProvider, shapes).stream()).collect(Collectors.toSet());
    }
}

