/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.List;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;
import software.amazon.smithy.utils.ListUtils;

abstract class MemberAndShapeTraitPlugin<S extends Shape, N extends Node, T extends Trait>
implements NodeValidatorPlugin {
    private final Class<S> targetShapeClass;
    private final Class<N> nodeClass;
    private final Class<T> traitClass;

    MemberAndShapeTraitPlugin(Class<S> targetShapeClass, Class<N> nodeClass, Class<T> traitClass) {
        this.targetShapeClass = targetShapeClass;
        this.nodeClass = nodeClass;
        this.traitClass = traitClass;
    }

    @Override
    public final List<String> apply(Shape shape, Node value, ShapeIndex index) {
        if (this.nodeClass.isInstance(value) && shape.getTrait(this.traitClass).isPresent() && this.isMatchingShape(shape, index)) {
            return this.check(shape, (Trait)shape.getTrait(this.traitClass).get(), value, index);
        }
        return ListUtils.of();
    }

    private boolean isMatchingShape(Shape shape, ShapeIndex index) {
        if (this.targetShapeClass.isInstance(shape)) {
            return true;
        }
        return shape.asMemberShape().flatMap(member -> index.getShape(member.getTarget())).filter(this.targetShapeClass::isInstance).isPresent();
    }

    protected abstract List<String> check(Shape var1, T var2, N var3, ShapeIndex var4);
}

