/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeToBuilder;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.StringListTrait;
import software.amazon.smithy.model.traits.TagsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.Tagged;

public abstract class Shape
implements FromSourceLocation,
Tagged,
ToShapeId,
Comparable<Shape> {
    private final ShapeId id;
    private final Map<ShapeId, Trait> traits;
    private final SourceLocation source;
    private final ShapeType type;

    Shape(AbstractShapeBuilder builder, boolean expectMemberSegments) {
        this.id = Shape.validateShapeId(this.getType(), (ShapeId)SmithyBuilder.requiredState((String)"id", (Object)builder.id), expectMemberSegments);
        this.source = builder.source;
        this.traits = MapUtils.copyOf(builder.traits);
        this.type = builder.getShapeType();
    }

    private static ShapeId validateShapeId(ShapeType type, ShapeId shapeId, boolean expectMember) {
        if (expectMember) {
            if (!shapeId.getMember().isPresent()) {
                throw new IllegalArgumentException(String.format("Shapes of type `%s` must contain a member in their shape ID. Found `%s`", new Object[]{type, shapeId}));
            }
        } else if (shapeId.getMember().isPresent()) {
            throw new IllegalArgumentException(String.format("Shapes of type `%s` cannot contain a member in their shape ID. Found `%s`", new Object[]{type, shapeId}));
        }
        return shapeId;
    }

    public static <B extends AbstractShapeBuilder<B, S>, S extends Shape> B shapeToBuilder(S shape) {
        return (B)shape.accept(new ShapeToBuilder());
    }

    public final ShapeType getType() {
        return this.type;
    }

    public abstract <R> R accept(ShapeVisitor<R> var1);

    public static <R> ShapeVisitor.Builder<R> visitor() {
        return new ShapeVisitor.Builder();
    }

    public final ShapeId getId() {
        return this.id;
    }

    public boolean hasTrait(String id) {
        return this.findTrait(id).isPresent();
    }

    public boolean hasTrait(ShapeId id) {
        return this.findTrait(id).isPresent();
    }

    public boolean hasTrait(Class<? extends Trait> traitClass) {
        return this.getTrait(traitClass).isPresent();
    }

    public Optional<Trait> findTrait(ShapeId id) {
        return Optional.ofNullable(this.traits.get(id));
    }

    public Optional<Trait> findTrait(String id) {
        return this.findTrait(ShapeId.from(Trait.makeAbsoluteName(id)));
    }

    public final <T extends Trait> Optional<T> getTrait(Class<T> traitClass) {
        return this.traits.values().stream().filter(traitClass::isInstance).findFirst().map(trait -> trait);
    }

    public final Map<ShapeId, Trait> getAllTraits() {
        return this.traits;
    }

    public Optional<BigDecimalShape> asBigDecimalShape() {
        return Optional.empty();
    }

    public Optional<BigIntegerShape> asBigIntegerShape() {
        return Optional.empty();
    }

    public Optional<BlobShape> asBlobShape() {
        return Optional.empty();
    }

    public Optional<BooleanShape> asBooleanShape() {
        return Optional.empty();
    }

    public Optional<ByteShape> asByteShape() {
        return Optional.empty();
    }

    public Optional<ShortShape> asShortShape() {
        return Optional.empty();
    }

    public Optional<FloatShape> asFloatShape() {
        return Optional.empty();
    }

    public Optional<DocumentShape> asDocumentShape() {
        return Optional.empty();
    }

    public Optional<DoubleShape> asDoubleShape() {
        return Optional.empty();
    }

    public Optional<IntegerShape> asIntegerShape() {
        return Optional.empty();
    }

    public Optional<ListShape> asListShape() {
        return Optional.empty();
    }

    public Optional<SetShape> asSetShape() {
        return Optional.empty();
    }

    public Optional<LongShape> asLongShape() {
        return Optional.empty();
    }

    public Optional<MapShape> asMapShape() {
        return Optional.empty();
    }

    public Optional<MemberShape> asMemberShape() {
        return Optional.empty();
    }

    public Optional<OperationShape> asOperationShape() {
        return Optional.empty();
    }

    public Optional<ResourceShape> asResourceShape() {
        return Optional.empty();
    }

    public Optional<ServiceShape> asServiceShape() {
        return Optional.empty();
    }

    public Optional<StringShape> asStringShape() {
        return Optional.empty();
    }

    public Optional<StructureShape> asStructureShape() {
        return Optional.empty();
    }

    public Optional<UnionShape> asUnionShape() {
        return Optional.empty();
    }

    public Optional<TimestampShape> asTimestampShape() {
        return Optional.empty();
    }

    public final boolean isBigDecimalShape() {
        return this.getType() == ShapeType.BIG_DECIMAL;
    }

    public final boolean isBigIntegerShape() {
        return this.getType() == ShapeType.BIG_INTEGER;
    }

    public final boolean isBlobShape() {
        return this.getType() == ShapeType.BLOB;
    }

    public final boolean isBooleanShape() {
        return this.getType() == ShapeType.BOOLEAN;
    }

    public final boolean isByteShape() {
        return this.getType() == ShapeType.BYTE;
    }

    public final boolean isShortShape() {
        return this.getType() == ShapeType.SHORT;
    }

    public final boolean isFloatShape() {
        return this.getType() == ShapeType.FLOAT;
    }

    public final boolean isDocumentShape() {
        return this.getType() == ShapeType.DOCUMENT;
    }

    public final boolean isDoubleShape() {
        return this.getType() == ShapeType.DOUBLE;
    }

    public final boolean isListShape() {
        return this.getType() == ShapeType.LIST;
    }

    public final boolean isSetShape() {
        return this.getType() == ShapeType.SET;
    }

    public final boolean isIntegerShape() {
        return this.getType() == ShapeType.INTEGER;
    }

    public final boolean isLongShape() {
        return this.getType() == ShapeType.LONG;
    }

    public final boolean isMapShape() {
        return this.getType() == ShapeType.MAP;
    }

    public final boolean isMemberShape() {
        return this.getType() == ShapeType.MEMBER;
    }

    public final boolean isOperationShape() {
        return this.getType() == ShapeType.OPERATION;
    }

    public final boolean isResourceShape() {
        return this.getType() == ShapeType.RESOURCE;
    }

    public final boolean isServiceShape() {
        return this.getType() == ShapeType.SERVICE;
    }

    public final boolean isStringShape() {
        return this.getType() == ShapeType.STRING;
    }

    public final boolean isStructureShape() {
        return this.getType() == ShapeType.STRUCTURE;
    }

    public final boolean isUnionShape() {
        return this.getType() == ShapeType.UNION;
    }

    public final boolean isTimestampShape() {
        return this.getType() == ShapeType.TIMESTAMP;
    }

    @Override
    public ShapeId toShapeId() {
        return this.id;
    }

    public final List<String> getTags() {
        return this.getTrait(TagsTrait.class).map(StringListTrait::getValues).orElseGet(Collections::emptyList);
    }

    @Override
    public final SourceLocation getSourceLocation() {
        return this.source;
    }

    @Override
    public int compareTo(Shape other) {
        return this.getId().compareTo(other.getId());
    }

    public final String toString() {
        return "(" + (Object)((Object)this.getType()) + ": `" + this.getId() + "`)";
    }

    public int hashCode() {
        return this.getId().hashCode() + 3 * this.getType().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Shape)) {
            return false;
        }
        Shape other = (Shape)o;
        return this.getId().equals(other.getId()) && this.getType() == other.getType() && this.traits.equals(other.traits);
    }
}

