/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.AndSelector;
import software.amazon.smithy.model.selector.AttributeSelector;
import software.amazon.smithy.model.selector.EachSelector;
import software.amazon.smithy.model.selector.NeighborSelector;
import software.amazon.smithy.model.selector.NotSelector;
import software.amazon.smithy.model.selector.OfSelector;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.selector.ShapeTypeCategorySelector;
import software.amazon.smithy.model.selector.ShapeTypeSelector;
import software.amazon.smithy.model.selector.TestSelector;
import software.amazon.smithy.model.selector.TraitAttributeKey;
import software.amazon.smithy.model.selector.WrappedSelector;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.NumberShape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

final class Parser {
    private static final Set<Character> BREAK_TOKENS = SetUtils.of((Object[])new Character[]{Character.valueOf(','), Character.valueOf(']'), Character.valueOf(')')});
    private static final Set<String> REL_TYPES = new HashSet<String>();
    private static final List<String> FUNCTIONS = ListUtils.of((Object[])new String[]{"test", "each", "of", "not"});
    private static final List<String> ATTRIBUTES = ListUtils.of((Object[])new String[]{"trait|", "id|namespace", "id|name", "id|member", "id", "service|version"});
    private static final List<String> AFTER_ATTRIBUTE = ListUtils.of((Object[])new String[]{"=", "^=", "$=", "*=", "]"});
    private static final List<String> AFTER_ATTRIBUTE_RHS = ListUtils.of((Object[])new String[]{"i]", "]"});
    private static final List<String> START_FUNCTION = ListUtils.of((Object)"(");
    private static final List<String> FUNCTION_ARG_NEXT_TOKEN = ListUtils.of((Object[])new String[]{")", ","});
    private static final List<String> MULTI_EDGE_NEXT_ARG_TOKEN = ListUtils.of((Object[])new String[]{",", "]->"});
    private static final List<String> EXPRESSION_TOKENS = new ArrayList<String>(Arrays.asList(":", "[", ">", "-[", "*", "number", "simpleType", "collection"));
    private final String expression;
    private int position = 0;

    private Parser(String selector) {
        this.expression = selector;
        this.ws();
    }

    static Selector parse(String selector) {
        return new WrappedSelector(selector, AndSelector.of(new Parser(selector).expression()));
    }

    private List<Selector> expression() {
        List<Selector> selectors = this.recursiveParse();
        this.ws();
        if (this.position != this.expression.length()) {
            throw this.syntax("Invalid expression");
        }
        return selectors;
    }

    private List<Selector> recursiveParse() {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        selectors.add(this.createSelector(this.expect(EXPRESSION_TOKENS)));
        while (this.position != this.expression.length() && !BREAK_TOKENS.contains(Character.valueOf(this.expression.charAt(this.position)))) {
            selectors.add(this.createSelector(this.expect(EXPRESSION_TOKENS)));
        }
        return selectors;
    }

    private void ws() {
        while (this.position < this.expression.length() && Character.isWhitespace(this.expression.charAt(this.position))) {
            ++this.position;
        }
    }

    private char charPeek() {
        return this.position == this.expression.length() ? (char)'\u0000' : this.expression.charAt(this.position);
    }

    private String expect(Collection<String> tokens) {
        for (String token : tokens) {
            if (!this.compareExpressionSlice(token)) continue;
            this.position += token.length();
            this.ws();
            return token;
        }
        throw this.syntax("Expected one of the following tokens: " + ValidationUtils.tickedList(tokens));
    }

    private boolean compareExpressionSlice(String token) {
        if (token.length() > this.expression.length() - this.position) {
            return false;
        }
        for (int i = 0; i < token.length(); ++i) {
            if (token.charAt(i) == this.expression.charAt(this.position + i)) continue;
            return false;
        }
        return true;
    }

    private SelectorSyntaxException syntax(String message) {
        return new SelectorSyntaxException(message, this.expression, this.position);
    }

    private Selector createSelector(String token) {
        switch (token) {
            case ">": {
                return new NeighborSelector(ListUtils.of());
            }
            case "-[": {
                return this.parseMultiEdgeDirectedNeighbor();
            }
            case "[": {
                return this.parseAttribute();
            }
            case ":": {
                return this.parseFunction();
            }
            case "*": {
                return Selector.IDENTITY;
            }
            case "number": {
                return new ShapeTypeCategorySelector(NumberShape.class);
            }
            case "simpleType": {
                return new ShapeTypeCategorySelector(SimpleShape.class);
            }
            case "collection": {
                return new ShapeTypeCategorySelector(CollectionShape.class);
            }
        }
        ShapeType shape = ShapeType.fromString(token).orElseThrow(() -> this.syntax("Unreachable token " + token));
        return new ShapeTypeSelector(shape);
    }

    private Selector parseMultiEdgeDirectedNeighbor() {
        String next;
        ArrayList<String> relationships = new ArrayList<String>();
        do {
            relationships.add(this.expect(REL_TYPES));
        } while (!(next = this.expect(MULTI_EDGE_NEXT_ARG_TOKEN)).equals("]->"));
        return new NeighborSelector(relationships);
    }

    private Selector parseFunction() {
        String name;
        switch (name = this.expect(FUNCTIONS)) {
            case "not": {
                return this.parseVariadic(NotSelector::new);
            }
            case "test": {
                return this.parseVariadic(TestSelector::new);
            }
            case "each": {
                return this.parseVariadic(EachSelector::of);
            }
            case "of": {
                return this.parseVariadic(OfSelector::new);
            }
        }
        throw new RuntimeException("Unreachable function case " + name);
    }

    private Selector parseVariadic(Function<List<Selector>, Selector> creator) {
        String next;
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        this.expect(START_FUNCTION);
        do {
            selectors.add(AndSelector.of(this.recursiveParse()));
        } while (!(next = this.expect(FUNCTION_ARG_NEXT_TOKEN)).equals(")"));
        return creator.apply(selectors);
    }

    private Selector parseAttribute() {
        AttributeSelector.Comparator comparator;
        String comparatorLexeme;
        AttributeSelector.KeyGetter attributeKey = this.parseAttributeKey();
        switch (comparatorLexeme = this.expect(AFTER_ATTRIBUTE)) {
            case "]": {
                return new AttributeSelector(attributeKey);
            }
            case "=": {
                comparator = AttributeSelector.EQUALS;
                break;
            }
            case "^=": {
                comparator = AttributeSelector.STARTS_WITH;
                break;
            }
            case "$=": {
                comparator = AttributeSelector.ENDS_WITH;
                break;
            }
            case "*=": {
                comparator = AttributeSelector.CONTAINS;
                break;
            }
            default: {
                throw this.syntax("Unreachable attribute comparator case for " + comparatorLexeme);
            }
        }
        String value = this.parseAttributeValue();
        this.ws();
        String afterValue = this.expect(AFTER_ATTRIBUTE_RHS);
        boolean insensitive = afterValue.equals("i]");
        return new AttributeSelector(attributeKey, comparator, value, insensitive);
    }

    private AttributeSelector.KeyGetter parseAttributeKey() {
        String namespace;
        switch (namespace = this.expect(ATTRIBUTES)) {
            case "trait|": {
                return new TraitAttributeKey(this.parseAttributeValue());
            }
            case "id": {
                return AttributeSelector.KEY_ID;
            }
            case "id|namespace": {
                return AttributeSelector.KEY_ID_NAMESPACE;
            }
            case "id|name": {
                return AttributeSelector.KEY_ID_NAME;
            }
            case "id|member": {
                return AttributeSelector.KEY_ID_MEMBER;
            }
            case "service|version": {
                return AttributeSelector.KEY_SERVICE_VERSION;
            }
        }
        throw this.syntax("Unreachable attribute case for " + namespace);
    }

    private String parseAttributeValue() {
        switch (this.charPeek()) {
            case '\'': {
                return this.consumeInside('\'');
            }
            case '\"': {
                return this.consumeInside('\"');
            }
        }
        return this.parseIdentifier();
    }

    private String consumeInside(char c) {
        for (int i = ++this.position; i < this.expression.length(); ++i) {
            if (this.expression.charAt(i) != c) continue;
            String result = this.expression.substring(this.position, i);
            this.position = i + 1;
            this.ws();
            return result;
        }
        throw this.syntax("Expected " + c + " to close " + this.expression.substring(this.position));
    }

    private String parseIdentifier() {
        StringBuilder builder = new StringBuilder();
        char current = this.charPeek();
        if (!this.validAttributeIdentifier(current)) {
            throw this.syntax("Invalid attribute start character `" + current + "`");
        }
        builder.append(current);
        ++this.position;
        current = this.charPeek();
        while (this.validInnerAttributeIdentifier(current)) {
            builder.append(current);
            ++this.position;
            current = this.charPeek();
        }
        return builder.toString();
    }

    private boolean validAttributeIdentifier(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    private boolean validInnerAttributeIdentifier(char c) {
        return this.validAttributeIdentifier(c) || c == '.' || c == '-' || c == '#';
    }

    static {
        for (RelationshipType relationshipType : RelationshipType.values()) {
            relationshipType.getSelectorLabel().ifPresent(REL_TYPES::add);
        }
        for (Enum enum_ : ShapeType.values()) {
            EXPRESSION_TOKENS.add(((ShapeType)enum_).toString());
        }
    }
}

