/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class ValidatorDefinition {
    final String name;
    final List<String> namespaces = new ArrayList<String>();
    ObjectNode configuration = Node.objectNode();
    SourceLocation sourceLocation = SourceLocation.none();
    Severity severity;
    String message;
    Selector selector;
    private final String id;

    ValidatorDefinition(String name, String id) {
        this.name = name;
        this.id = id;
    }

    List<ValidationEvent> map(Model model, List<ValidationEvent> events) {
        ArrayList<ValidationEvent> filtered = new ArrayList<ValidationEvent>(events.size());
        Set candidates = null;
        if (this.selector != null) {
            NeighborProvider provider = model.getKnowledge(NeighborProviderIndex.class).getProvider();
            candidates = this.selector.select(provider, model.getShapeIndex()).stream().map(Shape::getId).collect(Collectors.toSet());
        }
        for (ValidationEvent event : events) {
            if (!this.filterEvent(event, candidates)) continue;
            if (this.name.equals(this.id) && this.severity == null && this.message == null) {
                filtered.add(event);
                continue;
            }
            ValidationEvent.Builder builder = event.toBuilder();
            builder.eventId(this.id != null ? this.id : event.getEventId());
            builder.severity(this.severity != null ? this.severity : event.getSeverity());
            if (this.message != null) {
                builder.message(this.message.replace("{super}", event.getMessage()));
            }
            filtered.add(builder.build());
        }
        return filtered;
    }

    private boolean filterEvent(ValidationEvent event, Set<ShapeId> candidates) {
        ShapeId target = event.getShapeId().orElse(null);
        if (target != null) {
            if (!this.namespaces.isEmpty() && !this.namespaces.contains(target.getNamespace())) {
                return false;
            }
            if (candidates != null && !candidates.contains(target)) {
                return false;
            }
        }
        return true;
    }
}

