/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public class ShapeIdConflictValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex index = model.getShapeIndex();
        Map<String, List> conflicts = index.shapes().collect(Collectors.groupingBy(shape -> shape.getId().toString().toLowerCase(Locale.US))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return conflicts.values().stream().flatMap(this::emitEvents).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> emitEvents(List<Shape> collidingShapes) {
        List collidingIds = collidingShapes.stream().map(Shape::getId).sorted().collect(Collectors.toList());
        return collidingShapes.stream().map(value -> {
            String collideString = collidingIds.stream().filter(id -> !id.equals(value.getId())).map(id -> "`" + id + "`").collect(Collectors.joining(", "));
            return this.error((Shape)value, String.format("Shape ID `%s` conflicts with other shape IDs in the model: [%s]", value.getId(), collideString));
        });
    }
}

