/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpErrorTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;

public final class HttpResponseCodeSemanticsValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        events.addAll(this.validateOperations(model.getShapeIndex()));
        events.addAll(this.validateErrors(model.getShapeIndex()));
        return events;
    }

    private List<ValidationEvent> validateOperations(ShapeIndex index) {
        return index.shapes(OperationShape.class).flatMap(shape -> Trait.flatMapStream(shape, HttpTrait.class)).filter(pair -> ((HttpTrait)pair.getRight()).getCode() < 200 || ((HttpTrait)pair.getRight()).getCode() >= 300).map(pair -> this.invalidOperation((Shape)pair.getLeft(), (HttpTrait)pair.getRight())).collect(Collectors.toList());
    }

    private ValidationEvent invalidOperation(Shape shape, HttpTrait trait) {
        return this.danger(shape, trait, "Expected an `http` code in the 2xx range, but found " + trait.getCode());
    }

    private List<ValidationEvent> validateErrors(ShapeIndex index) {
        return index.shapes(StructureShape.class).flatMap(shape -> Trait.flatMapStream(shape, ErrorTrait.class)).flatMap(pair -> OptionalUtils.stream(this.validateError((StructureShape)pair.getLeft(), (ErrorTrait)pair.getRight()))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateError(StructureShape shape, ErrorTrait error) {
        return shape.getTrait(HttpErrorTrait.class).flatMap(httpErrorTrait -> {
            int code = httpErrorTrait.getCode();
            if (error.isClientError() && (code < 400 || code >= 500)) {
                return Optional.of(this.invalidError(shape, (Trait)httpErrorTrait, code, "4xx", error.getValue()));
            }
            if (error.isServerError() && (code < 500 || code >= 600)) {
                return Optional.of(this.invalidError(shape, (Trait)httpErrorTrait, code, "5xx", error.getValue()));
            }
            return Optional.empty();
        });
    }

    private ValidationEvent invalidError(Shape shape, Trait trait, int code, String range, String errorValue) {
        return this.danger(shape, trait, String.format("Expected an `httpError` code in the %s range for a `%s` error, but found %s", range, errorValue, code));
    }
}

