/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.List;
import java.util.Objects;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class XmlNamespaceTrait
extends AbstractTrait
implements ToSmithyBuilder<XmlNamespaceTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#xmlNamespace");
    private static final List<String> XML_NAMESPACE_PROPERTIES = ListUtils.of((Object)"uri");
    private final String uri;

    private XmlNamespaceTrait(Builder builder) {
        super(ID, builder.getSourceLocation());
        this.uri = (String)SmithyBuilder.requiredState((String)"uri", (Object)builder.uri);
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withMember("uri", Node.from(this.uri));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)XmlNamespaceTrait.builder().sourceLocation(this.getSourceLocation())).uri(this.uri);
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public XmlNamespaceTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)XmlNamespaceTrait.builder().sourceLocation(value);
            ObjectNode node = value.expectObjectNode();
            node.warnIfAdditionalProperties(XML_NAMESPACE_PROPERTIES);
            builder.uri(node.expectStringMember("uri").getValue());
            return builder.build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<XmlNamespaceTrait, Builder> {
        private String uri;

        private Builder() {
        }

        public Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri);
            return this;
        }

        public XmlNamespaceTrait build() {
            return new XmlNamespaceTrait(this);
        }
    }
}

