/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TraitTargetValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        NeighborProvider neighborProvider = model.getKnowledge(NeighborProviderIndex.class).getProvider();
        return model.shapes().flatMap(shape -> this.getSelectors((Shape)shape, model)).filter(check -> !this.matchesSelector((SelectorCheck)check, model, neighborProvider)).map(check -> this.error(check.shape, String.format("Trait `%s` cannot be applied to `%s`. This trait may only be applied to shapes that match the following selector: %s", Trait.getIdiomaticTraitName(check.trait.toShapeId()), check.shape.getId(), check.selector))).collect(Collectors.toList());
    }

    private Stream<SelectorCheck> getSelectors(Shape shape, Model model) {
        return shape.getAllTraits().values().stream().map(trait -> new SelectorCheck(shape, (Trait)trait, this.resolveSelector((Trait)trait, model)));
    }

    private Selector resolveSelector(Trait trait, Model model) {
        return model.getTraitDefinition(trait).map(TraitDefinition::getSelector).orElse(Selector.IDENTITY);
    }

    private boolean matchesSelector(SelectorCheck check, Model model, NeighborProvider neighborProvider) {
        return check.selector.select(neighborProvider, model).contains(check.shape);
    }

    private static final class SelectorCheck {
        final Shape shape;
        final Trait trait;
        final Selector selector;

        SelectorCheck(Shape shape, Trait trait, Selector selector) {
            this.shape = shape;
            this.trait = trait;
            this.selector = selector;
        }
    }
}

