/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public class SingleOperationBindingValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        TopDownIndex topDownIndex = model.getKnowledge(TopDownIndex.class);
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(topDownIndex, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(TopDownIndex topDownIndex, ServiceShape service) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : topDownIndex.getContainedOperations(service)) {
            ShapeId id = operation.getId();
            HashSet<EntityShape> containers = new HashSet<EntityShape>();
            if (service.getOperations().contains(id)) {
                containers.add(service);
            }
            for (ResourceShape resource : topDownIndex.getContainedResources(service.getId())) {
                if (!resource.getAllOperations().contains(id)) continue;
                containers.add(resource);
            }
            if (containers.size() <= 1) continue;
            events.add(this.error(operation, String.format("An operation can appear only once in an entire service closure. This operation is illegally bound into the `%s` service closure from multiple shapes: %s", service.getId(), containers.stream().map(Object::toString).sorted().collect(Collectors.joining(", ")))));
        }
        return events;
    }
}

