/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.EventStreamTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

public class EventStreamValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        OperationIndex operationIndex = model.getKnowledge(OperationIndex.class);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        ArrayList<Shape> eventStreamStructures = new ArrayList<Shape>();
        model.shapes(OperationShape.class).forEach(operation -> {
            operationIndex.getInput((ToShapeId)operation).ifPresent(input -> {
                for (MemberShape member : input.getAllMembers().values()) {
                    if (!member.hasTrait(EventStreamTrait.class)) continue;
                    eventStreamStructures.add((Shape)input);
                    events.addAll(this.check(model, (OperationShape)operation, member, "input"));
                }
            });
            operationIndex.getOutput((ToShapeId)operation).ifPresent(output -> {
                for (MemberShape member : output.getAllMembers().values()) {
                    if (!member.hasTrait(EventStreamTrait.class)) continue;
                    eventStreamStructures.add((Shape)output);
                    events.addAll(this.check(model, (OperationShape)operation, member, "output"));
                }
            });
        });
        events.addAll(this.validateEventStreamTargets(model, eventStreamStructures));
        return events;
    }

    private List<ValidationEvent> check(Model model, OperationShape operation, MemberShape member, String inputOrOutputName) {
        Shape target = model.getShape(member.getTarget()).orElse(null);
        if (target == null) {
            return Collections.emptyList();
        }
        EventStreamTrait trait = member.getTrait(EventStreamTrait.class).get();
        if (target.asUnionShape().isPresent()) {
            String invalidMembers = target.asUnionShape().get().getAllMembers().values().stream().map(em -> Pair.of((Object)em.getMemberName(), (Object)model.getShape(em.getTarget()).orElse(null))).filter(pair -> pair.getRight() != null && !(pair.getRight() instanceof StructureShape)).map(Pair::getLeft).sorted().collect(Collectors.joining(", "));
            if (!invalidMembers.isEmpty()) {
                return ListUtils.of((Object)this.error(operation, trait, String.format("Operation %s member `%s` targets an invalid union `%s`; each member of an event stream union must target a structure shape, but the following union members do not: [%s]", inputOrOutputName, member.getId(), target.getId(), invalidMembers)));
            }
        } else if (!target.isStructureShape()) {
            return ListUtils.of((Object)this.error(operation, trait, String.format("Operation %s member `%s` is referenced by the `%s` trait, so it must target a structure or union, but found %s, a %s.", new Object[]{inputOrOutputName, member.getId(), trait.toShapeId().getName(), target.getId(), target.getType()})));
        }
        return ListUtils.of();
    }

    private List<ValidationEvent> validateEventStreamTargets(Model model, List<Shape> shapes) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        NeighborProvider provider = model.getKnowledge(NeighborProviderIndex.class).getReverseProvider();
        for (Shape shape : shapes) {
            for (Relationship rel : provider.getNeighbors(shape)) {
                if (rel.getRelationshipType() == RelationshipType.INPUT || rel.getRelationshipType() == RelationshipType.OUTPUT || rel.getRelationshipType().getDirection() != RelationshipDirection.DIRECTED) continue;
                events.add(this.error(rel.getShape(), String.format("This shape has an invalid `%s` relationship to a structure, `%s`, that contains an event stream", new Object[]{rel.getRelationshipType(), shape.getId()})));
            }
        }
        return events;
    }
}

