/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class DeprecatedTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        Set deprecatedTraits = model.getTraitShapes().stream().filter(trait -> trait.hasTrait(DeprecatedTrait.class)).map(Shape::getId).collect(Collectors.toSet());
        return model.shapes().flatMap(shape -> this.validateShape(model, (Shape)shape, deprecatedTraits).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateShape(Model model, Shape shape, Set<ShapeId> deprecatedTraits) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        shape.getAllTraits().forEach((shapeId, trait) -> {
            if (!deprecatedTraits.contains(trait.toShapeId())) {
                return;
            }
            DeprecatedTrait deprecatedTrait = model.expectShape(trait.toShapeId()).expectTrait(DeprecatedTrait.class);
            String traitMessage = trait.toShapeId().toString();
            if (deprecatedTrait.getMessage().isPresent()) {
                traitMessage = traitMessage + ", " + deprecatedTrait.getMessage().get();
            }
            events.add(this.warning(shape, (FromSourceLocation)trait, String.format("This shape applies a trait that is deprecated: %s", traitMessage)));
        });
        return events;
    }
}

