/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;

public final class ArrayNode
extends Node
implements Iterable<Node> {
    static final ArrayNode EMPTY = new ArrayNode(ListUtils.of(), SourceLocation.none(), false);
    private static final Pattern CAST_PATTERN_TYPE = Pattern.compile("^.* to(?: class)? software\\.amazon\\.smithy\\.model\\.node\\.([A-Za-z]+).*$");
    private final List<Node> elements;

    public ArrayNode(List<Node> elements, SourceLocation sourceLocation) {
        this(elements, sourceLocation, true);
    }

    ArrayNode(List<Node> elements, SourceLocation sourceLocation, boolean defensiveCopy) {
        super(sourceLocation);
        this.elements = defensiveCopy ? ListUtils.copyOf(elements) : Collections.unmodifiableList(elements);
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public NodeType getType() {
        return NodeType.ARRAY;
    }

    @Override
    public <R> R accept(NodeVisitor<R> visitor) {
        return visitor.arrayNode(this);
    }

    @Override
    public ArrayNode expectArrayNode(String errorMessage) {
        return this;
    }

    @Override
    public Optional<ArrayNode> asArrayNode() {
        return Optional.of(this);
    }

    public List<Node> getElements() {
        return this.elements;
    }

    public Optional<Node> get(int index) {
        return this.elements.size() > index ? Optional.of(this.elements.get(index)) : Optional.empty();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    public ArrayNode withValue(Node node) {
        ArrayList<Node> newElements = new ArrayList<Node>(this.elements);
        newElements.add(Objects.requireNonNull(node));
        return new ArrayNode(newElements, this.getSourceLocation(), false);
    }

    public <T extends Node> List<T> getElementsAs(Class<T> type) {
        return this.getElementsAs(type::cast);
    }

    public <T, K extends Node> List<T> getElementsAs(Function<K, T> f) {
        ArrayList<T> result = new ArrayList<T>(this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            try {
                Node k = this.elements.get(i);
                result.add(f.apply(k));
                continue;
            }
            catch (ClassCastException e) {
                String message = e.getMessage();
                Matcher matcher = CAST_PATTERN_TYPE.matcher(message);
                String formatted = matcher.matches() ? String.format("Expected ArrayNode element %d to be a `%s` but found a `%s`.", i, matcher.group(1), this.elements.get(i).getClass().getSimpleName()) : String.format("ArrayNode element at position %d is an invalid type `%s`: %s", i, this.elements.get(i).getClass().getSimpleName(), e.getMessage());
                throw new ExpectationNotMetException(formatted, this.elements.get(i));
            }
        }
        return result;
    }

    public ArrayNode merge(ArrayNode other) {
        ArrayList<Node> result = new ArrayList<Node>(this.elements);
        result.addAll(other.elements);
        return new ArrayNode(result, this.getSourceLocation() != SourceLocation.NONE ? this.getSourceLocation() : other.getSourceLocation(), false);
    }

    public static <T extends ToNode> Collector<T, List<Node>, ArrayNode> collect() {
        return ArrayNode.collect(SourceLocation.NONE);
    }

    public static <T extends ToNode> Collector<T, List<Node>, ArrayNode> collect(SourceLocation sloc) {
        return Collector.of(ArrayList::new, (results, entry) -> results.add(entry.toNode()), (left, right) -> {
            left.addAll(right);
            return left;
        }, results -> new ArrayNode((List<Node>)results, sloc, false), new Collector.Characteristics[0]);
    }

    public boolean equals(Object other) {
        return other instanceof ArrayNode && this.elements.equals(((ArrayNode)other).elements);
    }

    public int hashCode() {
        return this.getType().hashCode() * 7 + this.elements.hashCode();
    }
}

