/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.traits.IdempotentTrait;
import software.amazon.smithy.model.traits.ReadonlyTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ResourceLifecycleValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex index = model.getShapeIndex();
        return model.getShapeIndex().shapes(ResourceShape.class).flatMap(shape -> this.validateResource(index, (ResourceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateResource(ShapeIndex index, ResourceShape resource) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        resource.getPut().flatMap(index::getShape).flatMap(Shape::asOperationShape).ifPresent(operation -> {
            this.validateReadonly(resource, (OperationShape)operation, "put", false).ifPresent(events::add);
            this.validateIdempotent(resource, (OperationShape)operation, "put", "").ifPresent(events::add);
        });
        resource.getCreate().flatMap(index::getShape).flatMap(Shape::asOperationShape).ifPresent(operation -> this.validateReadonly(resource, (OperationShape)operation, "create", false).ifPresent(events::add));
        resource.getRead().flatMap(index::getShape).flatMap(Shape::asOperationShape).ifPresent(operation -> this.validateReadonly(resource, (OperationShape)operation, "read", true).ifPresent(events::add));
        resource.getUpdate().flatMap(index::getShape).flatMap(Shape::asOperationShape).ifPresent(operation -> this.validateReadonly(resource, (OperationShape)operation, "update", false).ifPresent(events::add));
        resource.getDelete().flatMap(index::getShape).flatMap(Shape::asOperationShape).ifPresent(operation -> {
            this.validateReadonly(resource, (OperationShape)operation, "delete", false).ifPresent(events::add);
            this.validateIdempotent(resource, (OperationShape)operation, "delete", "").ifPresent(events::add);
        });
        resource.getList().flatMap(index::getShape).flatMap(Shape::asOperationShape).ifPresent(operation -> this.validateReadonly(resource, (OperationShape)operation, "list", true).ifPresent(events::add));
        return events;
    }

    private Optional<ValidationEvent> validateReadonly(ResourceShape resource, OperationShape operation, String lifecycle, boolean requireReadOnly) {
        if (requireReadOnly == operation.hasTrait(ReadonlyTrait.class)) {
            return Optional.empty();
        }
        return Optional.of(this.error(resource, String.format("The `%s` lifecycle operation of this resource targets an invalid operation, `%s`. The targeted operation %s be marked with the readonly trait.", lifecycle, operation.getId(), requireReadOnly ? "must" : "must not")));
    }

    private Optional<ValidationEvent> validateIdempotent(ResourceShape resource, OperationShape operation, String lifecycle, String additionalMessage) {
        if (operation.hasTrait(IdempotentTrait.class)) {
            return Optional.empty();
        }
        return Optional.of(this.error(resource, String.format("The `%s` lifecycle operation of this resource targets an invalid operation, `%s`. The targeted operation must be marked as idempotent.%s", lifecycle, operation.getId(), additionalMessage)));
    }
}

