/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.InputEventStreamTrait;
import software.amazon.smithy.model.traits.OutputEventStreamTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

public class EventStreamValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex index = model.getShapeIndex();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        model.getShapeIndex().shapes(OperationShape.class).flatMap(operation -> Trait.flatMapStream(operation, InputEventStreamTrait.class)).forEach(pair -> {
            OperationShape operation = (OperationShape)pair.getLeft();
            ShapeId input = operation.getInput().orElse(null);
            InputEventStreamTrait trait = (InputEventStreamTrait)pair.getRight();
            events.addAll(this.check(index, operation, input, trait, trait.getValue()));
        });
        model.getShapeIndex().shapes(OperationShape.class).flatMap(operation -> Trait.flatMapStream(operation, OutputEventStreamTrait.class)).forEach(pair -> {
            OperationShape operation = (OperationShape)pair.getLeft();
            ShapeId input = operation.getOutput().orElse(null);
            OutputEventStreamTrait trait = (OutputEventStreamTrait)pair.getRight();
            events.addAll(this.check(index, operation, input, trait, trait.getValue()));
        });
        return events;
    }

    private List<ValidationEvent> check(ShapeIndex index, OperationShape operation, ShapeId inputOutput, Trait trait, String member) {
        String inputOrOutputName;
        String string = inputOrOutputName = trait instanceof InputEventStreamTrait ? "input" : "output";
        if (inputOutput == null) {
            return ListUtils.of((Object)this.error(operation, trait, String.format("Operation has the `%s` but does not define an %s structure.", trait.toShapeId().getName(), inputOrOutputName)));
        }
        StructureShape struct = index.getShape(inputOutput).flatMap(Shape::asStructureShape).orElse(null);
        if (struct == null) {
            return ListUtils.of();
        }
        MemberShape actualMember = struct.getMember(member).orElse(null);
        if (actualMember == null) {
            return ListUtils.of((Object)this.error(operation, trait, String.format("Operation %s member `%s` was not found for the `%s` trait.", inputOrOutputName, member, trait.toShapeId().getName())));
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (actualMember.isRequired()) {
            events.add(this.error(operation, trait, String.format("Operation %s member `%s` is referenced by an `%s` trait, so it cannot be marked as required.", inputOrOutputName, actualMember.getId(), trait.toShapeId().getName())));
        }
        index.getShape(actualMember.getTarget()).ifPresent(referencedMember -> events.addAll(this.checkReferencedMember(index, operation, trait, actualMember, (Shape)referencedMember, inputOrOutputName)));
        return events;
    }

    private List<ValidationEvent> checkReferencedMember(ShapeIndex index, OperationShape operation, Trait trait, MemberShape member, Shape referencedMember, String inputOrOutputName) {
        if (referencedMember.asUnionShape().isPresent()) {
            String invalidMembers = referencedMember.asUnionShape().get().getAllMembers().values().stream().map(em -> Pair.of((Object)em.getMemberName(), (Object)index.getShape(em.getTarget()).orElse(null))).filter(pair -> pair.getRight() != null && !(pair.getRight() instanceof StructureShape)).map(Pair::getLeft).sorted().collect(Collectors.joining(", "));
            if (!invalidMembers.isEmpty()) {
                return ListUtils.of((Object)this.error(operation, trait, String.format("Operation %s member `%s` targets an invalid union `%s`; each member of an event stream union must target a structure shape, but the following union members do not: [%s]", inputOrOutputName, member.getId(), referencedMember.getId(), invalidMembers)));
            }
        } else if (!referencedMember.isStructureShape()) {
            return ListUtils.of((Object)this.error(operation, trait, String.format("Operation %s member `%s` is referenced by the `%s` trait, so it must target a structure or union, but found %s, a %s.", new Object[]{inputOrOutputName, member.getId(), trait.toShapeId().getName(), referencedMember.getId(), referencedMember.getType()})));
        }
        return ListUtils.of();
    }
}

