/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;

public class CollectionLengthPlugin
extends MemberAndShapeTraitPlugin<CollectionShape, ArrayNode, LengthTrait> {
    public CollectionLengthPlugin() {
        super(CollectionShape.class, ArrayNode.class, LengthTrait.class);
    }

    @Override
    protected List<String> check(Shape shape, LengthTrait trait, ArrayNode node, ShapeIndex index) {
        ArrayList<String> messages = new ArrayList<String>();
        trait.getMin().ifPresent(min -> {
            if ((long)node.size() < min) {
                messages.add(String.format("Value provided for `%s` must have at least %d elements, but the provided value only has %d elements", shape.getId(), min, node.size()));
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)node.size() > max) {
                messages.add(String.format("Value provided for `%s` must have no more than %d elements, but the provided value has %d elements", shape.getId(), max, node.size()));
            }
        });
        return messages;
    }
}

