/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ReferencesTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;
import software.amazon.smithy.utils.FunctionalUtils;

public final class CleanResourceReferences
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> shapes, Model model) {
        HashSet<Shape> toReplace = new HashSet<Shape>();
        shapes.forEach(shape -> toReplace.addAll(this.getAffectedStructures(model, (Shape)shape)));
        return transformer.replaceShapes(model, toReplace);
    }

    private Set<Shape> getAffectedStructures(Model model, Shape resource) {
        return model.getShapeIndex().shapes(StructureShape.class).flatMap(s -> Trait.flatMapStream(s, ReferencesTrait.class)).flatMap(pair -> {
            StructureShape subject = (StructureShape)pair.getLeft();
            ReferencesTrait trait = (ReferencesTrait)pair.getRight();
            List<ReferencesTrait.Reference> references = trait.getResourceReferences(resource.getId());
            if (references.isEmpty()) {
                return Stream.empty();
            }
            ReferencesTrait.Builder traitBuilder = trait.toBuilder().clearReferences();
            trait.getReferences().stream().filter(FunctionalUtils.not(references::contains)).forEach(traitBuilder::addReference);
            return Stream.of(((StructureShape.Builder)subject.toBuilder().addTrait(traitBuilder.build())).build());
        }).collect(Collectors.toSet());
    }
}

