/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.EnumConstantBody;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EnumTrait
extends AbstractTrait
implements ToSmithyBuilder<EnumTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#enum");
    private final Map<String, EnumConstantBody> constants;

    private EnumTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.constants = Collections.unmodifiableMap(new LinkedHashMap(builder.constants));
        if (this.constants.isEmpty()) {
            throw new SourceException("enum must have at least one entry", this.getSourceLocation());
        }
    }

    public Map<String, EnumConstantBody> getValues() {
        return this.constants;
    }

    @Override
    protected Node createNode() {
        return this.constants.entrySet().stream().map(entry -> {
            ObjectNode value = Node.objectNode().withOptionalMember("name", ((EnumConstantBody)entry.getValue()).getName().map(Node::from)).withOptionalMember("documentation", ((EnumConstantBody)entry.getValue()).getDocumentation().map(Node::from));
            if (!((EnumConstantBody)entry.getValue()).getTags().isEmpty()) {
                value = value.withMember("tags", ((EnumConstantBody)entry.getValue()).getTags().stream().map(Node::from).collect(ArrayNode.collect()));
            }
            return Pair.of((Object)((String)entry.getKey()), (Object)value);
        }).collect(ObjectNode.collectStringKeys(Pair::getLeft, Pair::getRight));
    }

    public Builder toBuilder() {
        Builder builder = (Builder)EnumTrait.builder().sourceLocation(this.getSourceLocation());
        this.constants.forEach(builder::addEnum);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public EnumTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)EnumTrait.builder().sourceLocation(value);
            value.expectObjectNode().getMembers().forEach((k, v) -> builder.addEnum(k.expectStringNode().getValue(), this.parseBody(v.expectObjectNode())));
            return builder.build();
        }

        private EnumConstantBody parseBody(ObjectNode value) {
            value.warnIfAdditionalProperties(Arrays.asList("name", "documentation", "tags"));
            EnumConstantBody.Builder builder = EnumConstantBody.builder().name(value.getStringMember("name").map(StringNode::getValue).orElse(null)).documentation(value.getStringMember("documentation").map(StringNode::getValue).orElse(null));
            value.getMember("tags").ifPresent(node -> builder.tags(Node.loadArrayOfString("tags", node)));
            return builder.build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<EnumTrait, Builder> {
        private final Map<String, EnumConstantBody> constants = new LinkedHashMap<String, EnumConstantBody>();

        public Builder addEnum(String name, EnumConstantBody value) {
            this.constants.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
            return this;
        }

        public Builder removeEnum(String value) {
            this.constants.remove(value);
            return this;
        }

        public Builder clearEnums() {
            this.constants.clear();
            return this;
        }

        public EnumTrait build() {
            return new EnumTrait(this);
        }
    }
}

