/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Model
implements ToSmithyBuilder<Model> {
    public static final String MODEL_VERSION = "0.4.0";
    private final Map<String, Node> metadata;
    private final ShapeIndex shapeIndex;
    private final String smithyVersion;
    private volatile Map<Shape, TraitDefinition> traitDefinitions;
    private final Map<Class<? extends KnowledgeIndex>, KnowledgeIndex> blackboard = new ConcurrentHashMap<Class<? extends KnowledgeIndex>, KnowledgeIndex>();
    private int hash;

    private Model(Builder builder) {
        this.smithyVersion = builder.smithyVersion;
        this.shapeIndex = builder.shapeIndex != null ? builder.shapeIndex : ShapeIndex.builder().build();
        this.metadata = builder.metadata.isEmpty() ? MapUtils.of() : MapUtils.copyOf((Map)builder.metadata);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ModelAssembler assembler() {
        return new ModelAssembler();
    }

    public static ModelAssembler assembler(ClassLoader classLoader) {
        return new ModelAssembler().traitFactory(TraitFactory.createServiceFactory(classLoader)).validatorFactory(ValidatorFactory.createServiceFactory(classLoader));
    }

    public ShapeIndex getShapeIndex() {
        return this.shapeIndex;
    }

    public Optional<Node> getMetadataProperty(String name) {
        return Optional.ofNullable(this.metadata.get(name));
    }

    public Map<String, Node> getMetadata() {
        return this.metadata;
    }

    public String getSmithyVersion() {
        return this.smithyVersion;
    }

    public Map<Shape, TraitDefinition> getTraitDefinitions() {
        if (this.traitDefinitions == null) {
            this.traitDefinitions = Collections.unmodifiableMap(this.shapeIndex.shapes().flatMap(shape -> Trait.flatMapStream(shape, TraitDefinition.class)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        }
        return this.traitDefinitions;
    }

    public Optional<TraitDefinition> getTraitDefinition(ToShapeId traitId) {
        return this.shapeIndex.getShape(traitId.toShapeId()).flatMap(shape -> shape.getTrait(TraitDefinition.class));
    }

    public Optional<TraitDefinition> getTraitDefinition(String traitId) {
        return this.getTraitDefinition(ShapeId.from(Trait.makeAbsoluteName(traitId)));
    }

    public Collection<Shape> getTraitShapes() {
        return this.getTraitDefinitions().keySet();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Model)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Model otherModel = (Model)other;
        return this.getSmithyVersion().equals(otherModel.getSmithyVersion()) && this.getMetadata().equals(otherModel.getMetadata()) && this.getShapeIndex().equals(otherModel.getShapeIndex());
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = Objects.hash(this.getSmithyVersion(), this.getMetadata(), this.getShapeIndex());
        }
        return result;
    }

    public Builder toBuilder() {
        return Model.builder().smithyVersion(this.smithyVersion).metadata(this.getMetadata()).shapeIndex(this.getShapeIndex());
    }

    public <T extends KnowledgeIndex> T getKnowledge(Class<T> type) {
        KnowledgeIndex value = this.blackboard.get(type);
        if (value == null) {
            value = KnowledgeIndex.create(type, this);
            this.blackboard.put(type, value);
        }
        return (T)value;
    }

    public static final class Builder
    implements SmithyBuilder<Model> {
        private Map<String, Node> metadata = new HashMap<String, Node>();
        private String smithyVersion = "0.4.0";
        private ShapeIndex shapeIndex;

        private Builder() {
        }

        public Builder smithyVersion(String smithyVersion) {
            this.smithyVersion = smithyVersion;
            return this;
        }

        public Builder metadata(Map<String, Node> metadata) {
            this.clearMetadata();
            this.metadata.putAll(metadata);
            return this;
        }

        public Builder putMetadataProperty(String key, Node value) {
            this.metadata.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
            return this;
        }

        public Builder clearMetadata() {
            this.metadata.clear();
            return this;
        }

        public Builder shapeIndex(ShapeIndex shapeIndex) {
            this.shapeIndex = Objects.requireNonNull(shapeIndex);
            return this;
        }

        public Model build() {
            return new Model(this);
        }
    }
}

