/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.List;
import java.util.function.Supplier;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.JarModelLoader;
import software.amazon.smithy.model.loader.LoaderVisitor;
import software.amazon.smithy.model.loader.NodeModelLoader;
import software.amazon.smithy.model.loader.SmithyModelLoader;
import software.amazon.smithy.model.node.DefaultNodeFactory;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;

@FunctionalInterface
interface ModelLoader {
    public boolean load(String var1, Supplier<String> var2, LoaderVisitor var3);

    public static ModelLoader composeLoaders(List<ModelLoader> loaders) {
        return (filename, contents, visitor) -> {
            for (ModelLoader modelLoader : loaders) {
                if (!modelLoader.load(filename, contents, visitor)) continue;
                return true;
            }
            return false;
        };
    }

    public static ModelLoader createDefaultLoader() {
        ModelLoader delegate = ModelLoader.composeLoaders(ListUtils.of((Object[])new ModelLoader[]{new NodeModelLoader(new DefaultNodeFactory()), new SmithyModelLoader()}));
        return ModelLoader.recoveringModelLoader(new JarModelLoader(delegate));
    }

    public static ModelLoader recoveringModelLoader(ModelLoader delegate) {
        return (filename, contents, visitor) -> {
            try {
                return delegate.load(filename, contents, visitor);
            }
            catch (SourceException e) {
                visitor.onError(ValidationEvent.fromSourceException(e));
                return true;
            }
        };
    }
}

