/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.traits.PrivateTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class PrivateAccessValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        Set privateShapes = model.getShapeIndex().shapes().filter(shape -> shape.getTrait(PrivateTrait.class).isPresent()).map(Shape::getId).collect(Collectors.toSet());
        NeighborProvider provider = model.getKnowledge(NeighborProviderIndex.class).getProvider();
        return model.getShapeIndex().shapes().filter(shape -> !(shape instanceof SimpleShape)).flatMap(shape -> this.validateNeighbors((Shape)shape, provider.getNeighbors((Shape)shape), privateShapes)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateNeighbors(Shape shape, List<Relationship> relationships, Set<ShapeId> privateShapes) {
        return relationships.stream().filter(rel -> privateShapes.contains(rel.getNeighborShapeId())).filter(rel -> !rel.getNeighborShapeId().getNamespace().equals(shape.getId().getNamespace())).map(rel -> this.error(shape, String.format("This shape has an invalid %s relationship that targets a private shape, `%s`, in another namespace.", rel.getRelationshipType().toString().toLowerCase(Locale.US), rel.getNeighborShapeId())));
    }
}

