/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.pattern.Pattern;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.EndpointTrait;
import software.amazon.smithy.model.traits.HostLabelTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public class HostLabelTraitValidator
extends AbstractValidator {
    private static final java.util.regex.Pattern EXPANDED_PATTERN = java.util.regex.Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-]{0,62}(?>\\.[a-zA-Z0-9-]{1,63})*\\.?$");

    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.getShapeIndex().shapes(OperationShape.class).flatMap(shape -> Trait.flatMapStream(shape, EndpointTrait.class)).flatMap(pair -> this.validateStructure(model.getShapeIndex(), (OperationShape)pair.getLeft(), (EndpointTrait)pair.getRight()).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateStructure(ShapeIndex index, OperationShape operation, EndpointTrait endpoint) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        this.validateExpandedPattern(operation, endpoint).ifPresent(events::add);
        if (!operation.getInput().isPresent() && !endpoint.getHostPrefix().getLabels().isEmpty()) {
            events.add(this.error(operation, endpoint, String.format("`endpoint` trait hostPrefix contains labels (%s), but operation has no input.", ValidationUtils.tickedList(endpoint.getHostPrefix().getLabels().stream().map(Pattern.Segment::getContent).collect(Collectors.toSet())))));
        } else {
            operation.getInput().flatMap(index::getShape).flatMap(Shape::asStructureShape).ifPresent(input -> events.addAll(this.validateBindings(operation, endpoint, (StructureShape)input)));
        }
        return events;
    }

    private List<ValidationEvent> validateBindings(OperationShape operation, EndpointTrait endpoint, StructureShape input) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Pattern hostPrefix = endpoint.getHostPrefix();
        Set labels = hostPrefix.getLabels().stream().map(Pattern.Segment::getContent).collect(Collectors.toSet());
        input.getAllMembers().values().stream().flatMap(member -> Trait.flatMapStream(member, HostLabelTrait.class)).forEach(pair -> {
            MemberShape member = (MemberShape)pair.getLeft();
            HostLabelTrait trait = (HostLabelTrait)pair.getRight();
            labels.remove(member.getMemberName());
            if (!hostPrefix.getLabel(member.getMemberName()).isPresent()) {
                events.add(this.error(member, trait, String.format("This `%s` structure member is marked with the `hostLabel` trait, but no corresponding `endpoint` label could be found when used as the input of the `%s` operation.", member.getMemberName(), operation.getId())));
            }
        });
        if (!labels.isEmpty()) {
            events.add(this.error(input, String.format("This structure is used as the input for the `%s` operation, but the following host labels found in the operation's `endpoint` trait do not have a corresponding member marked with the `hostLabel` trait: %s", operation.getId(), ValidationUtils.tickedList(labels))));
        }
        return events;
    }

    private Optional<ValidationEvent> validateExpandedPattern(OperationShape operation, EndpointTrait endpoint) {
        String stubHostPrefix = endpoint.getHostPrefix().getSegments().stream().map(segment -> segment.isLabel() ? "foo" : segment.getContent()).collect(Collectors.joining());
        if (!EXPANDED_PATTERN.matcher(stubHostPrefix).matches()) {
            return Optional.of(this.error(operation, endpoint, String.format("The `endpoint` trait hostPrefix, %s, could not expand in to a valid RFC 3986 host: %s", endpoint.getHostPrefix(), stubHostPrefix)));
        }
        return Optional.empty();
    }
}

