/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class MissingClientOptionalTrait
extends AbstractValidator {
    private final Config config;

    public MissingClientOptionalTrait(Config config) {
        this.config = config;
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (MemberShape member : model.getMemberShapes()) {
            if (member.hasTrait(ClientOptionalTrait.ID)) continue;
            if (member.hasTrait(DefaultTrait.ID) && this.config.onRequiredOrDefault) {
                events.add(this.danger((Shape)member, "@default members must also be marked with the @clientOptional trait"));
            }
            if (!member.hasTrait(RequiredTrait.ID)) continue;
            if (this.config.onRequiredOrDefault) {
                events.add(this.danger((Shape)member, "@required members must also be marked with the @clientOptional trait"));
                continue;
            }
            if (!this.config.onRequiredStructureOrUnion || !this.isTargetingStructureOrUnion(model, member)) continue;
            events.add(this.danger((Shape)member, "@required members that target a structure or union must be marked with the @clientOptional trait. Not using the @clientOptional trait here is risky because there is no backward compatible way to replace the @required trait with the @default trait if the member ever needs to be made optional."));
        }
        return events;
    }

    private boolean isTargetingStructureOrUnion(Model model, MemberShape member) {
        Shape target = model.expectShape(member.getTarget());
        return target.isStructureShape() || target.isUnionShape();
    }

    public static final class Config {
        private boolean onRequiredStructureOrUnion;
        private boolean onRequiredOrDefault;

        public boolean onRequiredStructureOrUnion() {
            return this.onRequiredStructureOrUnion;
        }

        public void onRequiredStructureOrUnion(boolean onRequiredStructuresOrUnion) {
            this.onRequiredStructureOrUnion = onRequiredStructuresOrUnion;
        }

        public boolean onRequiredOrDefault() {
            return this.onRequiredOrDefault;
        }

        public void onRequiredOrDefault(boolean onDefault) {
            this.onRequiredOrDefault = onDefault;
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(MissingClientOptionalTrait.class, configuration -> {
                NodeMapper mapper = new NodeMapper();
                Config config = (Config)mapper.deserialize((Node)configuration, Config.class);
                return new MissingClientOptionalTrait(config);
            });
        }
    }
}

