/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.linters.WordBoundaryMatcher;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

public final class MissingSensitiveTraitValidator
extends AbstractValidator {
    static final Set<String> DEFAULT_SENSITIVE_TERMS = SetUtils.of((Object[])new String[]{"account number", "bank", "billing address", "birth", "birth day", "citizenship", "credentials", "credit card", "csc", "driver license", "drivers license", "email", "ethnicity", "first name", "gender", "insurance", "ip address", "last name", "maiden name", "mailing address", "pass phrase", "pass word", "passport", "phone", "religion", "secret", "sexual orientation", "social security", "ssn", "tax payer", "telephone", "zip code"});
    private final WordBoundaryMatcher wordMatcher = new WordBoundaryMatcher();

    private MissingSensitiveTraitValidator(Config config) {
        if (config.getExcludeDefaults() && config.getTerms().isEmpty()) {
            throw new IllegalArgumentException("Cannot set 'excludeDefaults' to true and leave 'terms' unspecified.");
        }
        config.getTerms().forEach(this.wordMatcher::addSearch);
        if (!config.getExcludeDefaults()) {
            DEFAULT_SENSITIVE_TERMS.forEach(this.wordMatcher::addSearch);
        }
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> validationEvents = new ArrayList<ValidationEvent>();
        validationEvents.addAll(this.scanShapes(model));
        return validationEvents;
    }

    private List<ValidationEvent> scanShapes(Model model) {
        ArrayList<ValidationEvent> validationEvents = new ArrayList<ValidationEvent>();
        for (Shape shape : model.toSet()) {
            if (shape.isMemberShape()) {
                MemberShape memberShape = (MemberShape)shape;
                Shape containingShape = model.expectShape(memberShape.getContainer());
                Shape targetShape = model.expectShape(memberShape.getTarget());
                if (containingShape.hasTrait(SensitiveTrait.class) || containingShape.isEnumShape() || targetShape.hasTrait(SensitiveTrait.class)) continue;
                Optional<ValidationEvent> optionalValidationEvent = this.detectSensitiveTerms(memberShape.getMemberName(), (Shape)memberShape);
                optionalValidationEvent.ifPresent(validationEvents::add);
                continue;
            }
            if (shape.isOperationShape() || shape.isServiceShape() || shape.isResourceShape() || shape.hasTrait(SensitiveTrait.class)) continue;
            Optional<ValidationEvent> optionalValidationEvent = this.detectSensitiveTerms(shape.toShapeId().getName(), shape);
            optionalValidationEvent.ifPresent(validationEvents::add);
        }
        return validationEvents;
    }

    private Optional<ValidationEvent> detectSensitiveTerms(String name, Shape shape) {
        Optional<String> matchedTerm = this.wordMatcher.getFirstMatch(name);
        if (matchedTerm.isPresent()) {
            String message = shape.isMemberShape() ? String.format("This member possibly contains sensitive data but neither the enclosing nor target shape are marked with the sensitive trait (based on the presence of '%s')", matchedTerm.get()) : String.format("This shape possibly contains sensitive data but is not marked with the sensitive trait (based on the presence of '%s')", matchedTerm.get());
            return Optional.of(this.warning(shape, message));
        }
        return Optional.empty();
    }

    public static final class Config {
        private List<String> terms = ListUtils.of();
        private boolean excludeDefaults;

        public List<String> getTerms() {
            return this.terms;
        }

        public void setTerms(List<String> terms) {
            this.terms = terms;
        }

        public boolean getExcludeDefaults() {
            return this.excludeDefaults;
        }

        public void setExcludeDefaults(boolean excludeDefaults) {
            this.excludeDefaults = excludeDefaults;
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(MissingSensitiveTraitValidator.class, node -> {
                NodeMapper mapper = new NodeMapper();
                return new MissingSensitiveTraitValidator((Config)mapper.deserialize((Node)node, Config.class));
            });
        }
    }
}

