/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;

public final class AbbreviationNameValidator
extends AbstractValidator {
    private Config config;

    private AbbreviationNameValidator(Config config) {
        this.config = config;
    }

    public List<ValidationEvent> validate(Model model) {
        return model.shapes().flatMap(shape -> this.validateShapeName(model, (Shape)shape)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateShapeName(Model model, Shape shape) {
        Shape container;
        if (shape.isMemberShape() && ((container = model.expectShape(((MemberShape)shape.asMemberShape().get()).getContainer())).isEnumShape() || container.isIntEnumShape())) {
            return Stream.empty();
        }
        String descriptor = shape.isMemberShape() ? "member" : "shape";
        String name = shape.asMemberShape().map(MemberShape::getMemberName).orElseGet(() -> shape.getId().getName());
        String recommendedName = this.createRecommendedName(name);
        if (recommendedName.equals(name)) {
            return Stream.empty();
        }
        return Stream.of(this.danger(shape, String.format("%s name, `%s`, contains invalid abbreviations. Change this %s name to `%s`", descriptor, name, descriptor, recommendedName)));
    }

    private String createRecommendedName(String name) {
        StringBuilder recommendedWordBuilder = new StringBuilder();
        for (String word : ValidationUtils.splitCamelCaseWord((String)name)) {
            if (this.config.getAllowedAbbreviations().contains(word)) {
                recommendedWordBuilder.append(word);
                continue;
            }
            if (!this.isInvalidWord(word)) {
                recommendedWordBuilder.append(word);
                continue;
            }
            recommendedWordBuilder.append(word.substring(0, 1).toUpperCase(Locale.US));
            recommendedWordBuilder.append(word.substring(1).toLowerCase(Locale.US));
        }
        return recommendedWordBuilder.toString();
    }

    private boolean isInvalidWord(String word) {
        return word.chars().filter(c -> c >= 65 && c <= 90).count() > 1L;
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(AbbreviationNameValidator.class, configuration -> {
                NodeMapper mapper = new NodeMapper();
                return new AbbreviationNameValidator((Config)mapper.deserialize((Node)configuration, Config.class));
            });
        }
    }

    public static final class Config {
        private List<String> allowedAbbreviations = Collections.emptyList();

        public List<String> getAllowedAbbreviations() {
            return this.allowedAbbreviations;
        }

        public void setAllowedAbbreviations(List<String> allowedAbbreviations) {
            this.allowedAbbreviations = ListUtils.copyOf(allowedAbbreviations);
        }
    }
}

