/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class EmitEachSelectorValidator
extends AbstractValidator {
    private final Selector selector;

    private EmitEachSelectorValidator(Selector selector) {
        this.selector = selector;
    }

    private static Selector parse(StringNode expression) {
        try {
            return Selector.parse((String)expression.getValue().trim());
        }
        catch (SelectorSyntaxException e) {
            throw new SourceException("Invalid selector expression: " + e.getMessage(), (FromSourceLocation)expression, (Throwable)e);
        }
    }

    public List<ValidationEvent> validate(Model model) {
        return this.selector.select(model).stream().map(shape -> this.danger((Shape)shape, "Selector capture matched selector: " + this.selector)).collect(Collectors.toList());
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(EmitEachSelectorValidator.class, configuration -> {
                Selector selector = EmitEachSelectorValidator.parse(configuration.expectStringMember("selector"));
                return new EmitEachSelectorValidator(selector);
            });
        }
    }
}

