/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;

public final class DeprecatedAuthSchemesValidator
extends AbstractValidator {
    private static final List<String> ATTRIBUTES = ListUtils.of((Object[])new String[]{"schemes", "reason"});
    private final List<String> schemes;
    private final String reason;

    private DeprecatedAuthSchemesValidator(List<String> schemes, String reason) {
        this.schemes = schemes;
        this.reason = reason;
    }

    public List<ValidationEvent> validate(Model model) {
        return model.shapes(ServiceShape.class).flatMap(shape -> Trait.flatMapStream((Shape)shape, AuthTrait.class)).flatMap(pair -> this.validateAuthSchemes((ServiceShape)pair.getLeft(), (AuthTrait)pair.getRight())).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateAuthSchemes(ServiceShape service, AuthTrait trait) {
        return trait.getValues().stream().filter(this.schemes::contains).map(scheme -> this.warning((Shape)service, (FromSourceLocation)trait.getSourceLocation(), String.format("The %s auth scheme is deprecated. %s", scheme, this.reason)));
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(DeprecatedAuthSchemesValidator.class, configuration -> {
                configuration.warnIfAdditionalProperties((Collection)ATTRIBUTES);
                List schemes = Node.loadArrayOfString((String)"schemes", (Node)configuration.expectMember("schemes"));
                String reason = configuration.getStringMemberOrDefault("reason", "");
                return new DeprecatedAuthSchemesValidator(schemes, reason);
            });
        }
    }
}

