/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.Pair;

public class InputOutputStructureReuseValidator
extends AbstractValidator {
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        ShapeIndex index = model.getShapeIndex();
        Map<ShapeId, Set<ShapeId>> inputs = InputOutputStructureReuseValidator.createStructureToOperation(index, OperationShape::getInput);
        Map<ShapeId, Set<ShapeId>> outputs = InputOutputStructureReuseValidator.createStructureToOperation(index, OperationShape::getOutput);
        HashSet<ShapeId> both = new HashSet<ShapeId>(inputs.keySet());
        both.retainAll(outputs.keySet());
        both.stream().map(id -> this.emitWhenBothInputAndOutput(index, (ShapeId)id, (Set)inputs.get(id), (Set)outputs.get(id))).forEach(events::add);
        events.addAll(this.emitShared(index, inputs, "input"));
        events.addAll(this.emitShared(index, outputs, "output"));
        return events;
    }

    private List<ValidationEvent> emitShared(ShapeIndex index, Map<ShapeId, Set<ShapeId>> mapping, String descriptor) {
        return mapping.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).map(entry -> this.emitWhenShared(index, (ShapeId)entry.getKey(), (Set)entry.getValue(), descriptor)).collect(Collectors.toList());
    }

    private static Map<ShapeId, Set<ShapeId>> createStructureToOperation(ShapeIndex index, Function<OperationShape, Optional<ShapeId>> f) {
        return index.shapes(OperationShape.class).flatMap(shape -> Pair.flatMapStream((Object)shape, (Function)f)).collect(Collectors.groupingBy(Pair::getRight, HashMap::new, Collectors.mapping(pair -> ((OperationShape)pair.getLeft()).getId(), Collectors.toSet())));
    }

    private ValidationEvent emitWhenBothInputAndOutput(ShapeIndex index, ShapeId structure, Set<ShapeId> inputs, Set<ShapeId> outputs) {
        return this.emit(index, structure, String.format("Using the same structure for both input and output can lead to backward-compatibility problems in the future if the members or traits used in input needs to diverge from those used in output. It is always better to use structures that are exclusively used as input or exclusively used as output, and it is typically best to not share these structures across multiple operations. This structure is used as input in the following operations: [%s]. It is used as output in the following operations: [%s]", ValidationUtils.tickedList(inputs), ValidationUtils.tickedList(outputs)));
    }

    private ValidationEvent emitWhenShared(ShapeIndex index, ShapeId structure, Set<ShapeId> operations, String descriptor) {
        return this.emit(index, structure, String.format("Referencing the same %1$s structure from multiple operations can lead to backward-compatibility problems in the future if the %1$ss ever need to diverge. By using the same structure, you are unnecessarily tying the interfaces of these operations together. This structure isreferenced as %1$s by the following operations: [%2$s]", descriptor, ValidationUtils.tickedList(operations)));
    }

    private ValidationEvent emit(ShapeIndex index, ShapeId shape, String message) {
        ValidationEvent.Builder builder = ValidationEvent.builder().eventId(this.getName()).severity(Severity.DANGER).message(message).shapeId((ToShapeId)shape);
        index.getShape(shape).ifPresent(arg_0 -> ((ValidationEvent.Builder)builder).shape(arg_0));
        return builder.build();
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(InputOutputStructureReuseValidator.class, InputOutputStructureReuseValidator::new);
        }
    }
}

