/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ProtocolsTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;

public final class DeprecatedProtocolsValidator
extends AbstractValidator {
    private static final List<String> ATTRIBUTES = ListUtils.of((Object[])new String[]{"protocols", "reason"});
    private final List<String> protocols;
    private final String reason;

    private DeprecatedProtocolsValidator(List<String> protocols, String reason) {
        this.protocols = protocols;
        this.reason = reason;
    }

    public List<ValidationEvent> validate(Model model) {
        return model.getShapeIndex().shapes(ServiceShape.class).flatMap(shape -> Trait.flatMapStream((Shape)shape, ProtocolsTrait.class)).flatMap(pair -> this.validateProtocols((ServiceShape)pair.getLeft(), (ProtocolsTrait)pair.getRight())).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateProtocols(ServiceShape service, ProtocolsTrait trait) {
        return trait.getProtocolNames().stream().filter(this.protocols::contains).map(protocol -> this.warning((Shape)service, (FromSourceLocation)trait.getSourceLocation(), String.format("The %s protocol is deprecated. %s", protocol, this.reason)));
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(DeprecatedProtocolsValidator.class, configuration -> {
                configuration.warnIfAdditionalProperties((Collection)ATTRIBUTES);
                List protocols = Node.loadArrayOfString((String)"protocols", (Node)configuration.expectMember("protocols"));
                String reason = configuration.getStringMemberOrDefault("reason", "");
                return new DeprecatedProtocolsValidator(protocols, reason);
            });
        }
    }
}

