/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.jsonschema.SmithyJsonSchemaException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Schema
implements ToNode,
ToSmithyBuilder<Schema> {
    private static final Logger LOGGER = Logger.getLogger(Schema.class.getName());
    private final String ref;
    private final String type;
    private final Collection<String> enumValues;
    private final Collection<Integer> intEnumValues;
    private final Node constValue;
    private final Node defaultValue;
    private final Number multipleOf;
    private final Number maximum;
    private final Number exclusiveMaximum;
    private final Number minimum;
    private final Number exclusiveMinimum;
    private final Long maxLength;
    private final Long minLength;
    private final String pattern;
    private final Schema items;
    private final Integer maxItems;
    private final Integer minItems;
    private final boolean uniqueItems;
    private final Integer maxProperties;
    private final Integer minProperties;
    private final Collection<String> required;
    private final Map<String, Schema> properties;
    private final Schema additionalProperties;
    private final Schema propertyNames;
    private final Map<String, Schema> patternProperties;
    private final List<Schema> allOf;
    private final List<Schema> anyOf;
    private final List<Schema> oneOf;
    private final Schema not;
    private final String title;
    private final String description;
    private final String format;
    private final boolean readOnly;
    private final boolean writeOnly;
    private final String comment;
    private final Node examples;
    private final String contentEncoding;
    private final String contentMediaType;
    private final Map<String, ToNode> extensions;
    private Node asNode;

    private Schema(Builder builder) {
        this.ref = builder.ref;
        this.type = builder.type;
        this.enumValues = Collections.unmodifiableCollection(builder.enumValues);
        this.intEnumValues = Collections.unmodifiableCollection(builder.intEnumValues);
        this.constValue = builder.constValue;
        this.defaultValue = builder.defaultValue;
        this.multipleOf = builder.multipleOf;
        this.maximum = builder.maximum;
        this.exclusiveMaximum = builder.exclusiveMaximum;
        this.minimum = builder.minimum;
        this.exclusiveMinimum = builder.exclusiveMinimum;
        this.maxLength = builder.maxLength;
        this.minLength = builder.minLength;
        this.pattern = builder.pattern;
        this.items = builder.items;
        this.maxItems = builder.maxItems;
        this.minItems = builder.minItems;
        this.uniqueItems = builder.uniqueItems;
        this.properties = builder.properties;
        this.additionalProperties = builder.additionalProperties;
        this.required = ListUtils.copyOf((Collection)builder.required);
        this.maxProperties = builder.maxProperties;
        this.minProperties = builder.minProperties;
        this.propertyNames = builder.propertyNames;
        this.patternProperties = builder.patternProperties;
        this.allOf = ListUtils.copyOf((Collection)builder.allOf);
        this.oneOf = ListUtils.copyOf((Collection)builder.oneOf);
        this.anyOf = ListUtils.copyOf((Collection)builder.anyOf);
        this.not = builder.not;
        this.title = builder.title;
        this.description = builder.description;
        this.format = builder.format;
        this.readOnly = builder.readOnly;
        this.writeOnly = builder.writeOnly;
        this.comment = builder.comment;
        this.examples = builder.examples;
        this.contentEncoding = builder.contentEncoding;
        this.contentMediaType = builder.contentMediaType;
        this.extensions = MapUtils.copyOf((Map)builder.extensions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getRef() {
        return Optional.ofNullable(this.ref);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<Collection<String>> getEnumValues() {
        return Optional.ofNullable(this.enumValues);
    }

    public Optional<Collection<Integer>> getIntEnumValues() {
        return Optional.ofNullable(this.intEnumValues);
    }

    public Optional<Node> getConstValue() {
        return Optional.ofNullable(this.constValue);
    }

    public Optional<Node> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public Optional<Number> getMultipleOf() {
        return Optional.ofNullable(this.multipleOf);
    }

    public Optional<Number> getMaximum() {
        return Optional.ofNullable(this.maximum);
    }

    public Optional<Number> getExclusiveMaximum() {
        return Optional.ofNullable(this.exclusiveMaximum);
    }

    public Optional<Number> getMinimum() {
        return Optional.ofNullable(this.minimum);
    }

    public Optional<Number> getExclusiveMinimum() {
        return Optional.ofNullable(this.exclusiveMinimum);
    }

    public Optional<Long> getMaxLength() {
        return Optional.ofNullable(this.maxLength);
    }

    public Optional<Long> getMinLength() {
        return Optional.ofNullable(this.minLength);
    }

    public Optional<String> getPattern() {
        return Optional.ofNullable(this.pattern);
    }

    public Optional<Schema> getItems() {
        return Optional.ofNullable(this.items);
    }

    public Optional<Integer> getMaxItems() {
        return Optional.ofNullable(this.maxItems);
    }

    public Optional<Integer> getMinItems() {
        return Optional.ofNullable(this.minItems);
    }

    public boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public Optional<Integer> getMaxProperties() {
        return Optional.ofNullable(this.maxProperties);
    }

    public Optional<Integer> getMinProperties() {
        return Optional.ofNullable(this.minProperties);
    }

    public Collection<String> getRequired() {
        return this.required;
    }

    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    public Optional<Schema> getProperty(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    public Optional<Schema> getAdditionalProperties() {
        return Optional.ofNullable(this.additionalProperties);
    }

    public Optional<Schema> getPropertyNames() {
        return Optional.ofNullable(this.propertyNames);
    }

    public Map<String, Schema> getPatternProperties() {
        return this.patternProperties;
    }

    public List<Schema> getAllOf() {
        return this.allOf;
    }

    public List<Schema> getAnyOf() {
        return this.anyOf;
    }

    public List<Schema> getOneOf() {
        return this.oneOf;
    }

    public Optional<Schema> getNot() {
        return Optional.ofNullable(this.not);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getFormat() {
        return Optional.ofNullable(this.format);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean getWriteOnly() {
        return this.writeOnly;
    }

    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public Optional<Node> getExamples() {
        return Optional.ofNullable(this.examples);
    }

    public Optional<String> getContentEncoding() {
        return Optional.ofNullable(this.contentEncoding);
    }

    public Optional<String> getContentMediaType() {
        return Optional.ofNullable(this.contentMediaType);
    }

    public Optional<ToNode> getExtension(String key) {
        return Optional.ofNullable(this.extensions.get(key));
    }

    public Map<String, ToNode> getAllExtensions() {
        return this.extensions;
    }

    public Node toNode() {
        if (this.asNode != null) {
            return this.asNode;
        }
        ObjectNode.Builder result = Node.objectNodeBuilder().withOptionalMember("type", this.getType().map(Node::from)).withOptionalMember("$ref", this.getRef().map(Node::from)).withOptionalMember("const", this.getConstValue()).withOptionalMember("default", this.getDefaultValue()).withOptionalMember("multipleOf", this.getMultipleOf().map(Node::from)).withOptionalMember("maximum", this.getMaximum().map(Node::from)).withOptionalMember("exclusiveMaximum", this.getExclusiveMaximum().map(Node::from)).withOptionalMember("minimum", this.getMinimum().map(Node::from)).withOptionalMember("exclusiveMinimum", this.getExclusiveMinimum().map(Node::from)).withOptionalMember("items", this.getItems().map(ToNode::toNode)).withOptionalMember("maxItems", this.getMaxItems().map(Node::from)).withOptionalMember("minItems", this.getMinItems().map(Node::from)).withOptionalMember("uniqueItems", this.uniqueItems ? Optional.of(Node.from((boolean)true)) : Optional.empty()).withOptionalMember("maxLength", this.getMaxLength().map(Node::from)).withOptionalMember("minLength", this.getMinLength().map(Node::from)).withOptionalMember("pattern", this.getPattern().map(Node::from)).withOptionalMember("additionalProperties", this.getAdditionalProperties().map(Schema::toNode)).withOptionalMember("propertyNames", this.getPropertyNames().map(Schema::toNode)).withOptionalMember("maxProperties", this.getMaxProperties().map(Node::from)).withOptionalMember("minProperties", this.getMinProperties().map(Node::from)).withOptionalMember("not", this.getNot().map(Schema::toNode)).withOptionalMember("comment", this.getComment().map(Node::from)).withOptionalMember("examples", this.getExamples()).withOptionalMember("title", this.getTitle().map(Node::from)).withOptionalMember("description", this.getDescription().map(Node::from)).withOptionalMember("format", this.getFormat().map(Node::from)).withOptionalMember("contentEncoding", this.getContentEncoding().map(Node::from)).withOptionalMember("contentMediaType", this.getContentMediaType().map(Node::from));
        if (!this.properties.isEmpty()) {
            result.withMember("properties", (ToNode)((ObjectNode)this.properties.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, e -> ((Schema)e.getValue()).toNode()))));
        }
        if (!this.patternProperties.isEmpty()) {
            result.withMember("patternProperties", (ToNode)((ObjectNode)this.patternProperties.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, e -> ((Schema)e.getValue()).toNode()))));
        }
        if (!this.required.isEmpty()) {
            result.withMember("required", (ToNode)((ArrayNode)this.required.stream().sorted().map(Node::from).collect(ArrayNode.collect())));
        }
        if (!this.enumValues.isEmpty() || !this.intEnumValues.isEmpty()) {
            ArrayNode.Builder builder = ArrayNode.builder();
            if (this.getIntEnumValues().isPresent()) {
                for (Integer i : this.getIntEnumValues().get()) {
                    builder.withValue((Number)i);
                }
            }
            if (this.getEnumValues().isPresent()) {
                for (String s : this.getEnumValues().get()) {
                    builder.withValue(s);
                }
            }
            result.withOptionalMember("enum", builder.build().asArrayNode());
        }
        if (!this.allOf.isEmpty()) {
            result.withMember("allOf", (ToNode)((ArrayNode)this.allOf.stream().collect(ArrayNode.collect())));
        }
        if (!this.anyOf.isEmpty()) {
            result.withMember("anyOf", (ToNode)((ArrayNode)this.anyOf.stream().collect(ArrayNode.collect())));
        }
        if (!this.oneOf.isEmpty()) {
            result.withMember("oneOf", (ToNode)((ArrayNode)this.oneOf.stream().collect(ArrayNode.collect())));
        }
        if (this.readOnly) {
            result.withMember("readOnly", (ToNode)Node.from((boolean)true));
        }
        if (this.writeOnly) {
            result.withMember("writeOnly", (ToNode)Node.from((boolean)true));
        }
        for (Map.Entry<String, ToNode> entry : this.extensions.entrySet()) {
            result.withMember(entry.getKey(), (ToNode)entry.getValue().toNode());
        }
        this.asNode = result.build();
        return this.asNode;
    }

    public Optional<Schema> selectSchema(String ... segments) {
        String name;
        if (segments.length == 0) {
            return Optional.of(this);
        }
        switch (name = segments[0]) {
            case "properties": {
                return segments.length == 1 ? Optional.empty() : this.getRecursiveSchema(this.getProperty(segments[1]), segments, 2);
            }
            case "allOf": {
                return this.getSchemaFromArray(this.allOf, segments);
            }
            case "anyOf": {
                return this.getSchemaFromArray(this.anyOf, segments);
            }
            case "oneOf": {
                return this.getSchemaFromArray(this.oneOf, segments);
            }
            case "propertyNames": {
                return this.getRecursiveSchema(this.getPropertyNames(), segments, 1);
            }
            case "items": {
                return this.getRecursiveSchema(this.getItems(), segments, 1);
            }
            case "additionalProperties": {
                return this.getAdditionalProperties();
            }
            case "not": {
                return this.getRecursiveSchema(this.getNot(), segments, 1);
            }
        }
        LOGGER.warning(() -> "Unsupported JSONPointer Schema segment: " + name);
        return Optional.empty();
    }

    private Optional<Schema> getRecursiveSchema(Optional<Schema> schema, String[] segments, int skipOffset) {
        return schema.flatMap(s -> {
            String[] remainingSegments = Arrays.copyOfRange(segments, skipOffset, segments.length);
            return s.selectSchema(remainingSegments);
        });
    }

    private Optional<Schema> getSchemaFromArray(List<Schema> schemaArray, String[] segments) {
        if (segments.length == 1) {
            return Optional.empty();
        }
        try {
            int position = segments[1].equals("-") ? schemaArray.size() - 1 : Integer.parseInt(segments[1]);
            return position > -1 && position < schemaArray.size() ? this.getRecursiveSchema(Optional.of(schemaArray.get(position)), segments, 2) : Optional.empty();
        }
        catch (NumberFormatException e) {
            throw new SmithyJsonSchemaException("Invalid JSON pointer number: " + e.getMessage());
        }
    }

    public Builder toBuilder() {
        Builder builder = new Builder().ref(this.ref).type(this.type).enumValues(this.enumValues).intEnumValues(this.intEnumValues).constValue(this.constValue).defaultValue(this.defaultValue).multipleOf(this.multipleOf).maximum(this.maximum).exclusiveMaximum(this.exclusiveMaximum).minimum(this.minimum).exclusiveMinimum(this.exclusiveMinimum).maxLength(this.maxLength).minLength(this.minLength).pattern(this.pattern).items(this.items).maxItems(this.maxItems).minItems(this.minItems).uniqueItems(this.uniqueItems).required(this.required).additionalProperties(this.additionalProperties).maxProperties(this.maxProperties).minProperties(this.minProperties).propertyNames(this.propertyNames).allOf(this.allOf).anyOf(this.anyOf).oneOf(this.oneOf).not(this.not).title(this.title).description(this.description).format(this.format).readOnly(this.readOnly).writeOnly(this.writeOnly).comment(this.comment).examples(this.examples).contentEncoding(this.contentEncoding).contentMediaType(this.contentMediaType);
        this.properties.forEach(builder::putProperty);
        this.patternProperties.forEach(builder::putPatternProperty);
        this.extensions.forEach(builder::putExtension);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        return this.toNode().equals(((Schema)o).toNode());
    }

    public int hashCode() {
        return Objects.hash(this.ref, this.type, this.properties, this.items);
    }

    public static final class Builder
    implements SmithyBuilder<Schema> {
        private String ref;
        private String type;
        private Collection<String> enumValues = ListUtils.of();
        private Collection<Integer> intEnumValues = ListUtils.of();
        private Node constValue;
        private Node defaultValue;
        private Number multipleOf;
        private Number maximum;
        private Number exclusiveMaximum;
        private Number minimum;
        private Number exclusiveMinimum;
        private Long maxLength;
        private Long minLength;
        private String pattern;
        private Schema items;
        private Integer maxItems;
        private Integer minItems;
        private boolean uniqueItems;
        private Integer maxProperties;
        private Integer minProperties;
        private Collection<String> required = new ArrayList<String>();
        private Map<String, Schema> properties = new LinkedHashMap<String, Schema>();
        private Schema additionalProperties;
        private Schema propertyNames;
        private Map<String, Schema> patternProperties = new LinkedHashMap<String, Schema>();
        private List<Schema> allOf = ListUtils.of();
        private List<Schema> anyOf = ListUtils.of();
        private List<Schema> oneOf = ListUtils.of();
        private Schema not;
        private String title;
        private String description;
        private String format;
        private boolean readOnly;
        private boolean writeOnly;
        private String comment;
        private Node examples;
        private String contentEncoding;
        private String contentMediaType;
        private final Map<String, ToNode> extensions = new HashMap<String, ToNode>();

        private Builder() {
        }

        public Schema build() {
            return new Schema(this);
        }

        public Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder defaultValue(Node defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder enumValues(Collection<String> enumValues) {
            this.enumValues = enumValues == null ? ListUtils.of() : enumValues;
            return this;
        }

        public Builder intEnumValues(Collection<Integer> intEnumValues) {
            this.intEnumValues = intEnumValues == null ? ListUtils.of() : intEnumValues;
            return this;
        }

        public Builder constValue(Node constValue) {
            this.constValue = constValue;
            return this;
        }

        public Builder multipleOf(Number multipleOf) {
            this.multipleOf = multipleOf;
            return this;
        }

        public Builder maximum(Number maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder exclusiveMaximum(Number exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        public Builder minimum(Number minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder exclusiveMinimum(Number exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        public Builder maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder minLength(Long minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder items(Schema items) {
            this.items = items;
            return this;
        }

        public Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder minItems(Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder uniqueItems(boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }

        public Builder maxProperties(Integer maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder minProperties(Integer minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        public Builder required(Collection<String> required) {
            if (required == null) {
                this.required.clear();
            } else {
                this.required = new ArrayList<String>(required);
            }
            return this;
        }

        public Builder properties(Map<String, Schema> properties) {
            this.properties.clear();
            if (properties != null) {
                properties.forEach(this::putProperty);
            }
            return this;
        }

        public Builder putProperty(String key, Schema value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder removeProperty(String key) {
            this.properties.remove(key);
            this.required.remove(key);
            return this;
        }

        public Builder additionalProperties(Schema additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder propertyNames(Schema propertyNames) {
            this.propertyNames = propertyNames;
            return this;
        }

        public Builder patternProperties(Map<String, Schema> patternProperties) {
            this.patternProperties.clear();
            if (patternProperties != null) {
                patternProperties.forEach(this::putPatternProperty);
            }
            return this;
        }

        public Builder putPatternProperty(String key, Schema value) {
            this.patternProperties.put(key, value);
            return this;
        }

        public Builder removePatternProperty(String key) {
            this.patternProperties.remove(key);
            return this;
        }

        public Builder allOf(List<Schema> allOf) {
            this.allOf = allOf == null ? ListUtils.of() : allOf;
            return this;
        }

        public Builder anyOf(List<Schema> anyOf) {
            this.anyOf = anyOf == null ? ListUtils.of() : anyOf;
            return this;
        }

        public Builder oneOf(List<Schema> oneOf) {
            this.oneOf = oneOf == null ? ListUtils.of() : oneOf;
            return this;
        }

        public Builder not(Schema not) {
            this.not = not;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Optional<String> getFormat() {
            return Optional.ofNullable(this.format);
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder writeOnly(boolean writeOnly) {
            this.writeOnly = writeOnly;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentMediaType(String contentMediaType) {
            this.contentMediaType = contentMediaType;
            return this;
        }

        public Builder examples(Node examples) {
            this.examples = examples;
            return this;
        }

        public Builder extensions(Map<String, Node> extensions) {
            this.extensions.clear();
            this.extensions.putAll(extensions);
            return this;
        }

        public Builder putExtension(String key, ToNode value) {
            this.extensions.put(key, value);
            return this;
        }

        public Builder removeExtension(String key) {
            this.extensions.remove(key);
            return this;
        }

        public Builder disableProperty(String propertyName) {
            switch (propertyName) {
                case "const": {
                    return this.constValue(null);
                }
                case "default": {
                    return this.defaultValue(null);
                }
                case "enum": {
                    return this.enumValues(null).intEnumValues(null);
                }
                case "multipleOf": {
                    return this.multipleOf(null);
                }
                case "maximum": {
                    return this.maximum(null);
                }
                case "exclusiveMaximum": {
                    return this.exclusiveMaximum(null);
                }
                case "minimum": {
                    return this.minimum(null);
                }
                case "exclusiveMinimum": {
                    return this.exclusiveMinimum(null);
                }
                case "maxLength": {
                    return this.maxLength(null);
                }
                case "minLength": {
                    return this.minLength(null);
                }
                case "pattern": {
                    return this.pattern(null);
                }
                case "items": {
                    return this.items(null);
                }
                case "maxItems": {
                    return this.maxItems(null);
                }
                case "minItems": {
                    return this.minItems(null);
                }
                case "uniqueItems": {
                    return this.uniqueItems(false);
                }
                case "properties": {
                    return this.properties(null);
                }
                case "additionalProperties": {
                    return this.additionalProperties(null);
                }
                case "required": {
                    return this.required(null);
                }
                case "maxProperties": {
                    return this.maxProperties(null);
                }
                case "minProperties": {
                    return this.minProperties(null);
                }
                case "propertyNames": {
                    return this.propertyNames(null);
                }
                case "allOf": {
                    return this.allOf(null);
                }
                case "anyOf": {
                    return this.anyOf(null);
                }
                case "oneOf": {
                    return this.oneOf(null);
                }
                case "not": {
                    return this.not(null);
                }
                case "title": {
                    return this.title(null);
                }
                case "description": {
                    return this.description(null);
                }
                case "format": {
                    return this.format(null);
                }
                case "readOnly": {
                    return this.readOnly(false);
                }
                case "writeOnly": {
                    return this.writeOnly(false);
                }
                case "comment": {
                    return this.comment(null);
                }
                case "contentEncoding": {
                    return this.contentEncoding(null);
                }
                case "contentMediaType": {
                    return this.contentMediaType(null);
                }
                case "examples": {
                    return this.examples(null);
                }
            }
            LOGGER.warning("Unknown JSON Schema config 'disable' property: " + propertyName);
            return this;
        }
    }
}

