/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.JsonNameTrait;

@FunctionalInterface
public interface PropertyNamingStrategy {
    public String toPropertyName(Shape var1, MemberShape var2, JsonSchemaConfig var3);

    public static PropertyNamingStrategy createMemberNameStrategy() {
        return (containingShape, member, config) -> member.getMemberName();
    }

    public static PropertyNamingStrategy createDefaultStrategy() {
        return (containingShape, member, config) -> {
            if (config.getUseJsonName() && member.hasTrait(JsonNameTrait.class)) {
                return ((JsonNameTrait)member.expectTrait(JsonNameTrait.class)).getValue();
            }
            return member.getMemberName();
        };
    }
}

