/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaComparator;
import software.amazon.smithy.jsonschema.SmithyJsonSchemaException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodePointer;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class SchemaDocument
implements ToNode,
ToSmithyBuilder<SchemaDocument> {
    private static final Logger LOGGER = Logger.getLogger(SchemaDocument.class.getName());
    private final String idKeyword;
    private final String schemaKeyword;
    private final Schema rootSchema;
    private final Map<String, Schema> definitions;
    private final ObjectNode extensions;

    private SchemaDocument(Builder builder) {
        this.idKeyword = builder.idKeyword;
        this.schemaKeyword = builder.schemaKeyword;
        this.rootSchema = builder.rootSchema != null ? builder.rootSchema : Schema.builder().build();
        this.definitions = new LinkedHashMap<String, Schema>(builder.definitions);
        this.extensions = builder.extensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Node toNode() {
        ObjectNode definitionNode = Node.objectNode();
        if (!this.definitions.isEmpty()) {
            for (Map.Entry<String, Schema> entry : this.definitions.entrySet()) {
                if (entry.getKey().startsWith("http")) {
                    LOGGER.info(() -> "Skipping the serialization of a remote schema reference: " + (String)entry.getKey());
                    continue;
                }
                NodePointer pointer = this.parseCheckedPointer(entry.getKey());
                definitionNode = pointer.addWithIntermediateValues((Node)definitionNode, entry.getValue().toNode()).expectObjectNode();
            }
        }
        return Node.objectNodeBuilder().withOptionalMember("$id", this.getIdKeyword().map(Node::from)).withOptionalMember("$schema", this.getSchemaKeyword().map(Node::from)).merge(this.rootSchema.toNode().expectObjectNode()).merge(this.extensions).merge(definitionNode).build().withDeepSortedKeys((Comparator)new SchemaComparator());
    }

    private NodePointer parseCheckedPointer(String pointer) {
        try {
            return NodePointer.parse((String)pointer);
        }
        catch (IllegalArgumentException e) {
            throw new SmithyJsonSchemaException("Invalid definition JSON pointer: " + e.getMessage(), e);
        }
    }

    public Builder toBuilder() {
        Builder builder = SchemaDocument.builder().idKeyword(this.idKeyword).schemaKeyword(this.schemaKeyword).rootSchema(this.rootSchema).extensions(this.extensions);
        this.definitions.forEach(builder::putDefinition);
        return builder;
    }

    public Schema getRootSchema() {
        return this.rootSchema;
    }

    public Optional<String> getIdKeyword() {
        return Optional.ofNullable(this.idKeyword);
    }

    public Optional<String> getSchemaKeyword() {
        return Optional.ofNullable(this.schemaKeyword);
    }

    public Optional<Schema> getDefinition(String pointer) {
        String unescaped = NodePointer.unescape((String)pointer);
        if (this.definitions.containsKey(unescaped)) {
            return Optional.ofNullable(this.definitions.get(unescaped));
        }
        List pointerParts = NodePointer.parse((String)pointer).getParts();
        if (pointerParts.isEmpty()) {
            return Optional.of(this.getRootSchema());
        }
        String prefix = pointer.startsWith("#") ? "#" : "";
        for (int position = 0; position < pointerParts.size(); ++position) {
            String part = (String)pointerParts.get(position);
            if (!this.definitions.containsKey(prefix = prefix + '/' + part)) continue;
            List remaining = pointerParts.subList(position + 1, pointerParts.size());
            String[] suffix = remaining.toArray(new String[0]);
            return this.definitions.get(prefix).selectSchema(suffix);
        }
        return Optional.empty();
    }

    public Map<String, Schema> getDefinitions() {
        return this.definitions;
    }

    public Optional<Node> getExtension(String key) {
        return this.extensions.getMember(key);
    }

    public ObjectNode getExtensions() {
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDocument)) {
            return false;
        }
        SchemaDocument that = (SchemaDocument)o;
        return Objects.equals(this.idKeyword, that.idKeyword) && Objects.equals(this.schemaKeyword, that.schemaKeyword) && this.rootSchema.equals(that.rootSchema) && this.definitions.equals(that.definitions) && this.extensions.equals((Object)that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.idKeyword, this.schemaKeyword, this.rootSchema);
    }

    public static final class Builder
    implements SmithyBuilder<SchemaDocument> {
        private String idKeyword;
        private String schemaKeyword;
        private Schema rootSchema;
        private ObjectNode extensions = Node.objectNode();
        private final Map<String, Schema> definitions = new LinkedHashMap<String, Schema>();

        private Builder() {
        }

        public SchemaDocument build() {
            return new SchemaDocument(this);
        }

        public Builder idKeyword(String idKeyword) {
            this.idKeyword = idKeyword;
            return this;
        }

        public Builder schemaKeyword(String schemaKeyword) {
            this.schemaKeyword = schemaKeyword;
            return this;
        }

        public Builder rootSchema(Schema rootSchema) {
            this.rootSchema = rootSchema;
            return this;
        }

        public Builder putDefinition(String name, Schema schema) {
            this.definitions.put(name, schema);
            return this;
        }

        public Builder removeDefinition(String name) {
            this.definitions.remove(name);
            return this;
        }

        public Builder extensions(ObjectNode extensions) {
            this.extensions = extensions;
            return this;
        }
    }
}

