/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import software.amazon.smithy.jsonschema.ConflictingShapeNameException;
import software.amazon.smithy.jsonschema.RefStrategy;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.StringUtils;

final class DeconflictingStrategy
implements RefStrategy {
    private static final Logger LOGGER = Logger.getLogger(DeconflictingStrategy.class.getName());
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\.");
    private final RefStrategy delegate;
    private final Map<ShapeId, String> pointers = new HashMap<ShapeId, String>();
    private final Map<String, ShapeId> reversePointers = new HashMap<String, ShapeId>();

    DeconflictingStrategy(Model model, RefStrategy delegate, Predicate<Shape> shapePredicate) {
        this.delegate = delegate;
        model.shapes().filter(shapePredicate.and(FunctionalUtils.not(this::isIgnoredShape))).sorted().forEach(shape -> {
            String pointer = delegate.toPointer(shape.getId());
            if (!this.reversePointers.containsKey(pointer)) {
                this.pointers.put(shape.getId(), pointer);
                this.reversePointers.put(pointer, shape.getId());
            } else {
                String deconflictedPointer = this.deconflict((Shape)shape, pointer, this.reversePointers);
                LOGGER.info(() -> String.format("De-conflicted `%s` JSON schema pointer from `%s` to `%s`", shape.getId(), pointer, deconflictedPointer));
                this.pointers.put(shape.getId(), deconflictedPointer);
                this.reversePointers.put(deconflictedPointer, shape.getId());
            }
        });
    }

    private boolean isIgnoredShape(Shape shape) {
        return shape instanceof SimpleShape && !shape.hasTrait(EnumTrait.class) || shape.isResourceShape() || shape.isServiceShape() || shape.isOperationShape() || shape.isMemberShape();
    }

    private String deconflict(Shape shape, String pointer, Map<String, ShapeId> reversePointers) {
        LOGGER.info(() -> String.format("Attempting to de-conflict `%s` JSON schema pointer `%s` that conflicts with `%s`", shape.getId(), pointer, reversePointers.get(pointer)));
        if (!this.isSafeToDeconflict(shape)) {
            throw new ConflictingShapeNameException(String.format("Shape %s conflicts with %s using a JSON schema pointer of %s", shape, reversePointers.get(pointer), pointer));
        }
        StringBuilder builder = new StringBuilder(pointer);
        for (String part : SPLIT_PATTERN.split(shape.getId().getNamespace())) {
            builder.append(StringUtils.capitalize((String)part));
        }
        String updatedPointer = builder.toString();
        if (reversePointers.containsKey(updatedPointer)) {
            throw new ConflictingShapeNameException(String.format("Unable to de-conflict shape %s because the de-conflicted name resolves to another generated name: %s", shape, updatedPointer));
        }
        return updatedPointer;
    }

    private boolean isSafeToDeconflict(Shape shape) {
        return shape instanceof CollectionShape || shape instanceof MapShape;
    }

    @Override
    public String toPointer(ShapeId id) {
        return this.pointers.computeIfAbsent(id, this.delegate::toPointer);
    }

    @Override
    public boolean isInlined(Shape shape) {
        return this.delegate.isInlined(shape);
    }
}

