/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.jsonschema.DisableMapper;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.JsonSchemaShapeVisitor;
import software.amazon.smithy.jsonschema.PropertyNamingStrategy;
import software.amazon.smithy.jsonschema.RefStrategy;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaDocument;
import software.amazon.smithy.jsonschema.SmithyJsonSchemaException;
import software.amazon.smithy.jsonschema.TimestampMapper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.UnitTypeTrait;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class JsonSchemaConverter
implements ToSmithyBuilder<JsonSchemaConverter> {
    private static final Logger LOGGER = Logger.getLogger(JsonSchemaConverter.class.getName());
    private static final PropertyNamingStrategy DEFAULT_PROPERTY_STRATEGY = PropertyNamingStrategy.createDefaultStrategy();
    private final List<JsonSchemaMapper> mappers = new ArrayList<JsonSchemaMapper>();
    private final Model model;
    private final PropertyNamingStrategy propertyNamingStrategy;
    private JsonSchemaConfig config;
    private final Predicate<Shape> shapePredicate;
    private final RefStrategy refStrategy;
    private final List<JsonSchemaMapper> realizedMappers;
    private final JsonSchemaShapeVisitor visitor;
    private final Shape rootShape;
    private final String rootDefinitionPointer;
    private final int rootDefinitionSegments;
    private final boolean unitTargetedByUnion;

    private JsonSchemaConverter(Builder builder) {
        this.mappers.addAll(builder.mappers);
        this.config = (JsonSchemaConfig)SmithyBuilder.requiredState((String)"config", (Object)builder.config);
        this.propertyNamingStrategy = (PropertyNamingStrategy)SmithyBuilder.requiredState((String)"propertyNamingStrategy", (Object)builder.propertyNamingStrategy);
        this.model = (Model)SmithyBuilder.requiredState((String)"model", (Object)builder.model);
        this.shapePredicate = builder.shapePredicate;
        LOGGER.fine("Building filtered JSON schema shape index");
        this.rootShape = builder.rootShape == null ? null : (Shape)builder.model.getShape(builder.rootShape).orElseThrow(() -> new SmithyJsonSchemaException("Invalid root shape (shape not found): " + builder.rootShape));
        LOGGER.fine("Creating JSON ref strategy");
        Model refModel = this.config.isEnableOutOfServiceReferences() ? this.model : JsonSchemaConverter.scopeModelToService(this.model, this.config.getService());
        this.unitTargetedByUnion = refModel.shapes(UnionShape.class).anyMatch(u -> u.members().stream().anyMatch(m -> m.getTarget().equals((Object)UnitTypeTrait.UNIT)));
        this.refStrategy = RefStrategy.createDefaultStrategy(refModel, this.config, this.propertyNamingStrategy, new FilterPreludeUnit(this.unitTargetedByUnion));
        this.realizedMappers = new ArrayList<JsonSchemaMapper>(this.mappers);
        this.realizedMappers.add(new DisableMapper());
        this.realizedMappers.add(new TimestampMapper());
        this.realizedMappers.sort(Comparator.comparing(JsonSchemaMapper::getOrder));
        LOGGER.fine(() -> "Adding the following JSON schema mappers: " + this.realizedMappers.stream().map(Object::getClass).map(Class::getCanonicalName).collect(Collectors.joining(", ")));
        this.visitor = new JsonSchemaShapeVisitor(this.model, this, this.realizedMappers);
        this.rootDefinitionPointer = this.config.getDefinitionPointer();
        this.rootDefinitionSegments = JsonSchemaConverter.countSegments(this.rootDefinitionPointer);
        LOGGER.fine(() -> "Using the following root JSON schema pointer: " + this.rootDefinitionPointer + " (" + this.rootDefinitionSegments + " segments)");
    }

    private static Model createUpdatedModel(Model model, Shape rootShape, Predicate<Shape> predicate) {
        ModelTransformer transformer = ModelTransformer.create();
        if (rootShape != null) {
            LOGGER.fine(() -> "Filtering out shapes that are not connected to " + rootShape);
            Set connected = new Walker(model).walkShapes(rootShape);
            LOGGER.fine(() -> "Only generating the following JSON schema shapes: " + connected.stream().map(Shape::getId).map(ShapeId::toString).collect(Collectors.joining(", ")));
            model = transformer.filterShapes(model, connected::contains);
        }
        model = transformer.filterShapes(model, predicate);
        model = transformer.scrubTraitDefinitions(model);
        return model;
    }

    private static Model scopeModelToService(Model model, ShapeId serviceId) {
        if (serviceId == null) {
            return model;
        }
        Set connected = new Walker(model).walkShapes(model.expectShape(serviceId));
        return ModelTransformer.create().filterShapes(model, connected::contains);
    }

    private static int countSegments(String pointer) {
        int totalSegments = 0;
        for (int i = 0; i < pointer.length(); ++i) {
            if (pointer.charAt(i) != '/') continue;
            ++totalSegments;
        }
        return totalSegments;
    }

    public static Builder builder() {
        return new Builder();
    }

    public JsonSchemaConfig getConfig() {
        return this.config;
    }

    public void setConfig(JsonSchemaConfig config) {
        this.config = config;
    }

    public String toPropertyName(MemberShape member) {
        Shape containingShape = (Shape)this.model.getShape(member.getContainer()).orElseThrow(() -> new SmithyJsonSchemaException("Invalid member: " + member));
        return this.propertyNamingStrategy.toPropertyName(containingShape, member, this.config);
    }

    public String toPointer(ToShapeId id) {
        return this.refStrategy.toPointer(id.toShapeId());
    }

    public boolean isTopLevelPointer(String pointer) {
        return pointer.startsWith(this.rootDefinitionPointer) && JsonSchemaConverter.countSegments(pointer) == this.rootDefinitionSegments + 1;
    }

    public boolean isInlined(Shape shape) {
        return this.refStrategy.isInlined(shape);
    }

    public SchemaDocument convert() {
        LOGGER.fine("Converting to JSON schema");
        SchemaDocument.Builder builder = SchemaDocument.builder();
        if (this.rootShape != null && !(this.rootShape instanceof ServiceShape)) {
            LOGGER.fine(() -> "Setting root schema to " + this.rootShape);
            builder.rootSchema((Schema)this.rootShape.accept((ShapeVisitor)this.visitor));
        }
        this.addExtensions(builder);
        Model updatedModel = JsonSchemaConverter.createUpdatedModel(this.model, this.rootShape, this.shapePredicate);
        this.model.shapes().filter(shape -> updatedModel.getShape(shape.getId()).isPresent()).filter(FunctionalUtils.not(Shape::isMemberShape)).filter(shape -> this.rootShape == null || !shape.getId().equals((Object)this.rootShape.getId())).filter(FunctionalUtils.not(this::isUnsupportedShapeType)).filter(s -> s.getId().equals((Object)UnitTypeTrait.UNIT) && this.unitTargetedByUnion || !Prelude.isPreludeShape((ToShapeId)s)).filter(FunctionalUtils.not(this.refStrategy::isInlined)).map(shape -> Pair.of((Object)this.toPointer((ToShapeId)shape), (Object)shape)).filter(pair -> this.isTopLevelPointer((String)pair.getLeft())).map(pair -> {
            LOGGER.fine(() -> "Converting " + pair.getRight() + " to JSON schema at " + (String)pair.getLeft());
            return Pair.of((Object)pair.getLeft(), (Object)((Shape)pair.getRight()).accept((ShapeVisitor)this.visitor));
        }).forEach(pair -> builder.putDefinition((String)pair.getLeft(), (Schema)pair.getRight()));
        LOGGER.fine(() -> "Completed JSON schema document conversion (root shape: " + this.rootShape + ")");
        return builder.build();
    }

    public SchemaDocument convertShape(Shape shape) {
        SchemaDocument.Builder builder = SchemaDocument.builder();
        builder.rootSchema((Schema)shape.accept((ShapeVisitor)this.visitor));
        return builder.build();
    }

    private boolean isUnsupportedShapeType(Shape shape) {
        return shape.isServiceShape() || shape.isResourceShape() || shape.isOperationShape();
    }

    private void addExtensions(SchemaDocument.Builder builder) {
        ObjectNode extensions = this.config.getSchemaDocumentExtensions();
        if (!extensions.isEmpty()) {
            LOGGER.fine(() -> "Adding JSON schema extensions: " + Node.prettyPrintJson((Node)extensions));
            builder.extensions(extensions);
        }
    }

    public Builder toBuilder() {
        return JsonSchemaConverter.builder().model(this.model).propertyNamingStrategy(this.propertyNamingStrategy).config(this.config).rootShape((ToShapeId)(this.rootShape == null ? null : this.rootShape.getId())).shapePredicate(this.shapePredicate).mappers(this.mappers);
    }

    static /* synthetic */ PropertyNamingStrategy access$700() {
        return DEFAULT_PROPERTY_STRATEGY;
    }

    static final class FilterPreludeUnit
    implements Predicate<Shape> {
        private final boolean includePreludeUnit;

        FilterPreludeUnit(boolean includePreludeUnit) {
            this.includePreludeUnit = includePreludeUnit;
        }

        @Override
        public boolean test(Shape shape) {
            return this.includePreludeUnit || !shape.getId().equals((Object)UnitTypeTrait.UNIT);
        }
    }

    public static final class Builder
    implements SmithyBuilder<JsonSchemaConverter> {
        private Model model;
        private ShapeId rootShape;
        private PropertyNamingStrategy propertyNamingStrategy = JsonSchemaConverter.access$700();
        private JsonSchemaConfig config = new JsonSchemaConfig();
        private Predicate<Shape> shapePredicate = shape -> true;
        private final List<JsonSchemaMapper> mappers = new ArrayList<JsonSchemaMapper>();

        private Builder() {
        }

        public JsonSchemaConverter build() {
            return new JsonSchemaConverter(this);
        }

        public Builder model(Model model) {
            this.model = model;
            return this;
        }

        public Builder rootShape(ToShapeId rootShape) {
            this.rootShape = rootShape == null ? null : rootShape.toShapeId();
            return this;
        }

        public Builder shapePredicate(Predicate<Shape> shapePredicate) {
            this.shapePredicate = Objects.requireNonNull(shapePredicate);
            return this;
        }

        public Builder config(JsonSchemaConfig config) {
            this.config = Objects.requireNonNull(config);
            return this;
        }

        public Builder propertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
            this.propertyNamingStrategy = Objects.requireNonNull(propertyNamingStrategy);
            return this;
        }

        public Builder addMapper(JsonSchemaMapper jsonSchemaMapper) {
            this.mappers.add(Objects.requireNonNull(jsonSchemaMapper));
            return this;
        }

        public Builder mappers(List<JsonSchemaMapper> jsonSchemaMappers) {
            this.mappers.clear();
            this.mappers.addAll(jsonSchemaMappers);
            return this;
        }
    }
}

