/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;

final class TimestampMapper
implements JsonSchemaMapper {
    TimestampMapper() {
    }

    @Override
    public byte getOrder() {
        return -120;
    }

    @Override
    public Schema.Builder updateSchema(Shape shape, Schema.Builder builder, JsonSchemaConfig config) {
        String format = TimestampMapper.extractTimestampFormat(shape, config);
        if (format == null) {
            return builder;
        }
        switch (format) {
            case "date-time": {
                return builder.type("string").format(format);
            }
            case "http-date": {
                return builder.type("string");
            }
            case "epoch-seconds": {
                return builder.format(null).type("number");
            }
        }
        return format.startsWith("epoch-") ? builder.type("number") : builder.type("string");
    }

    private static String extractTimestampFormat(Shape shape, JsonSchemaConfig config) {
        if (shape.isTimestampShape() || shape.hasTrait(TimestampFormatTrait.class)) {
            return shape.getTrait(TimestampFormatTrait.class).map(StringTrait::getValue).orElseGet(() -> config.getDefaultTimestampFormat().toString());
        }
        return null;
    }
}

