/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;

final class TimestampMapper
implements JsonSchemaMapper {
    private static final String DEFAULT_TIMESTAMP_FORMAT = "date-time";

    TimestampMapper() {
    }

    @Override
    public byte getOrder() {
        return -120;
    }

    @Override
    public Schema.Builder updateSchema(Shape shape, Schema.Builder builder, ObjectNode config) {
        String format = TimestampMapper.extractTimestampFormat(shape, config);
        if (format == null) {
            return builder;
        }
        switch (format) {
            case "date-time": {
                return builder.type("string").format(format);
            }
            case "http-date": {
                return builder.type("string");
            }
            case "epoch-seconds": {
                return builder.format(null).type("number");
            }
        }
        return format.startsWith("epoch-") ? builder.type("number") : builder.type("string");
    }

    private static String extractTimestampFormat(Shape shape, ObjectNode config) {
        if (shape.isTimestampShape() || shape.hasTrait(TimestampFormatTrait.class)) {
            return shape.getTrait(TimestampFormatTrait.class).map(StringTrait::getValue).orElseGet(() -> config.getStringMemberOrDefault("defaultTimestampFormat", DEFAULT_TIMESTAMP_FORMAT));
        }
        return null;
    }
}

