/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.Locale;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.StringUtils;

@FunctionalInterface
public interface RefStrategy {
    public static final String DEFAULT_POINTER = "#/definitions";

    public String toPointer(ShapeId var1, ObjectNode var2);

    public static RefStrategy createDefaultStrategy() {
        return (id, config) -> {
            StringBuilder builder = new StringBuilder();
            String pointer = config.getStringMemberOrDefault("definitionPointer", DEFAULT_POINTER);
            builder.append(pointer);
            if (!pointer.endsWith("/")) {
                builder.append('/');
            }
            if (!config.containsMember("stripNamespaces")) {
                for (String part : id.getNamespace().split("\\.")) {
                    builder.append(StringUtils.capitalize((String)part));
                }
            }
            builder.append(id.getName());
            id.getMember().ifPresent(memberName -> {
                builder.append(StringUtils.capitalize((String)memberName));
                if (!memberName.toLowerCase(Locale.US).endsWith("member")) {
                    builder.append("Member");
                }
            });
            return builder.toString();
        };
    }
}

