/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.jmespath.ExpressionProblem;
import software.amazon.smithy.jmespath.RuntimeType;

public final class LinterResult {
    private final RuntimeType returnType;
    private final Set<ExpressionProblem> problems;

    public LinterResult(RuntimeType returnType, Set<ExpressionProblem> problems) {
        this.returnType = returnType;
        this.problems = Collections.unmodifiableSet(problems);
    }

    public RuntimeType getReturnType() {
        return this.returnType;
    }

    public Set<ExpressionProblem> getProblems() {
        return this.problems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinterResult)) {
            return false;
        }
        LinterResult that = (LinterResult)o;
        return this.returnType == that.returnType && this.problems.equals(that.problems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.returnType, this.problems});
    }
}

