/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import software.amazon.smithy.jmespath.JmespathException;
import software.amazon.smithy.jmespath.Token;
import software.amazon.smithy.jmespath.TokenType;

final class TokenIterator
implements Iterator<Token> {
    private final List<Token> tokens;
    private int position;

    TokenIterator(List<Token> tokens) {
        this.tokens = tokens;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.tokens.size();
    }

    @Override
    public Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempted to parse past token EOF");
        }
        return this.tokens.get(this.position++);
    }

    Token peek() {
        return this.peek(0);
    }

    Token peek(int offset) {
        return this.position + offset < this.tokens.size() ? this.tokens.get(this.position + offset) : null;
    }

    Token expectNotEof() {
        Token peeked = this.peek();
        if (peeked == null) {
            throw this.syntax("Expected more tokens but found EOF");
        }
        return peeked;
    }

    Token expectPeek(TokenType type) {
        Token peeked = this.peek();
        if (peeked == null) {
            throw this.syntax("Expected " + (Object)((Object)type) + ", but found EOF");
        }
        if (peeked.type != type) {
            throw this.syntax("Expected " + (Object)((Object)type) + ", but found " + peeked);
        }
        return peeked;
    }

    Token expectPeek(TokenType ... types) {
        Token peeked = this.peek();
        if (peeked == null) {
            throw this.syntax("Expected " + Arrays.toString((Object[])types) + ", but found EOF");
        }
        for (TokenType type : types) {
            if (peeked.type != type) continue;
            return peeked;
        }
        throw this.syntax("Expected " + Arrays.toString((Object[])types) + ", but found " + peeked);
    }

    Token expect(TokenType type) {
        Token peeked = this.expectPeek(type);
        this.next();
        return peeked;
    }

    Token expect(TokenType ... types) {
        Token peeked = this.expectPeek(types);
        this.next();
        return peeked;
    }

    JmespathException syntax(String message) {
        return new JmespathException("Syntax error at line " + this.line() + " column " + this.column() + ": " + message);
    }

    int line() {
        Token peeked = this.peek();
        if (peeked != null) {
            return peeked.line;
        }
        if (this.position > 0) {
            return this.tokens.get((int)(this.position - 1)).line;
        }
        return 1;
    }

    int column() {
        Token peeked = this.peek();
        if (peeked != null) {
            return peeked.column;
        }
        if (this.position > 0) {
            return this.tokens.get((int)(this.position - 1)).column;
        }
        return 1;
    }
}

