/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;

public final class FilterProjectionExpression
extends JmespathExpression {
    private final JmespathExpression comparison;
    private final JmespathExpression left;
    private final JmespathExpression right;

    public FilterProjectionExpression(JmespathExpression left, JmespathExpression comparison, JmespathExpression right) {
        this(left, comparison, right, 1, 1);
    }

    public FilterProjectionExpression(JmespathExpression left, JmespathExpression comparison, JmespathExpression right, int line, int column) {
        super(line, column);
        this.left = left;
        this.right = right;
        this.comparison = comparison;
    }

    public JmespathExpression getLeft() {
        return this.left;
    }

    public JmespathExpression getRight() {
        return this.right;
    }

    public JmespathExpression getComparison() {
        return this.comparison;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitFilterProjection(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterProjectionExpression)) {
            return false;
        }
        FilterProjectionExpression that = (FilterProjectionExpression)o;
        return this.getComparison().equals(that.getComparison()) && this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
    }

    public int hashCode() {
        return Objects.hash(this.getComparison(), this.getLeft(), this.getRight());
    }

    public String toString() {
        return "FilterProjectionExpression{comparison=" + this.comparison + ", left=" + this.left + ", right=" + this.right + '}';
    }
}

