/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.ast.BinaryExpression;
import software.amazon.smithy.jmespath.ast.ComparatorType;

public final class ComparatorExpression
extends BinaryExpression {
    private final ComparatorType comparator;

    public ComparatorExpression(ComparatorType comparator, JmespathExpression left, JmespathExpression right) {
        this(comparator, left, right, 1, 1);
    }

    public ComparatorExpression(ComparatorType comparator, JmespathExpression left, JmespathExpression right, int line, int column) {
        super(left, right, line, column);
        this.comparator = comparator;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitComparator(this);
    }

    public ComparatorType getComparator() {
        return this.comparator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparatorExpression)) {
            return false;
        }
        ComparatorExpression that = (ComparatorExpression)o;
        return this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight()) && this.getComparator().equals((Object)that.getComparator());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getLeft(), this.getRight(), this.getComparator()});
    }

    @Override
    public String toString() {
        return "ComparatorExpression{comparator='" + (Object)((Object)this.getComparator()) + '\'' + ", left=" + this.getLeft() + ", right=" + this.getRight() + '}';
    }
}

