/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class AddedEntityBinding
extends AbstractDiffEvaluator {
    private static final String ADDED_RESOURCE = "AddedResourceBinding";
    private static final String ADDED_OPERATION = "AddedOperationBinding";

    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        differences.changedShapes(EntityShape.class).forEach(change -> this.validateOperation((ChangedShape<EntityShape>)change, (List<ValidationEvent>)events));
        return events;
    }

    private void validateOperation(ChangedShape<EntityShape> change, List<ValidationEvent> events) {
        this.findAdded(change.getOldShape().getOperations(), change.getNewShape().getOperations()).forEach(added -> events.add(this.createAddedEvent(ADDED_OPERATION, (EntityShape)change.getNewShape(), (ShapeId)added)));
        this.findAdded(change.getOldShape().getResources(), change.getNewShape().getResources()).forEach(added -> events.add(this.createAddedEvent(ADDED_RESOURCE, (EntityShape)change.getNewShape(), (ShapeId)added)));
    }

    private Set<ShapeId> findAdded(Set<ShapeId> oldShapes, Set<ShapeId> newShapes) {
        HashSet<ShapeId> added = new HashSet<ShapeId>(newShapes);
        added.removeAll(oldShapes);
        return added;
    }

    private ValidationEvent createAddedEvent(String eventId, EntityShape entity, ShapeId addedShape) {
        String descriptor = eventId.equals(ADDED_RESOURCE) ? "Resource" : "Operation";
        String message = String.format("%s binding of `%s` was added to the %s shape, `%s`", descriptor, addedShape, entity.getType(), entity.getId());
        return ValidationEvent.builder().id(eventId).severity(Severity.NOTE).shape((Shape)entity).message(message).build();
    }
}

