/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.DiffEvaluator;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationEventDecorator;
import software.amazon.smithy.model.validation.suppressions.ModelBasedEventDecorator;
import software.amazon.smithy.utils.SmithyBuilder;

public final class ModelDiff {
    private ModelDiff() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static List<ValidationEvent> compare(Model oldModel, Model newModel) {
        return ModelDiff.compare(ModelDiff.class.getClassLoader(), oldModel, newModel);
    }

    public static List<ValidationEvent> compare(ClassLoader classLoader, Model oldModel, Model newModel) {
        return ModelDiff.builder().oldModel(oldModel).newModel(newModel).classLoader(classLoader).compare().getDiffEvents();
    }

    public static final class Builder {
        private Model oldModel;
        private Model newModel;
        private List<ValidationEvent> oldModelEvents = Collections.emptyList();
        private List<ValidationEvent> newModelEvents = Collections.emptyList();
        private ClassLoader classLoader = ModelDiff.class.getClassLoader();

        private Builder() {
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = Objects.requireNonNull(classLoader);
            return this;
        }

        public Builder oldModel(Model oldModel) {
            this.oldModel = Objects.requireNonNull(oldModel);
            return this;
        }

        public Builder newModel(Model newModel) {
            this.newModel = Objects.requireNonNull(newModel);
            return this;
        }

        public Builder oldModel(ValidatedResult<Model> oldModel) {
            this.oldModel = (Model)oldModel.getResult().orElseThrow(() -> new IllegalArgumentException("No old model present in ValidatedResult"));
            this.oldModelEvents = oldModel.getValidationEvents();
            return this;
        }

        public Builder newModel(ValidatedResult<Model> newModel) {
            this.newModel = (Model)newModel.getResult().orElseThrow(() -> new IllegalArgumentException("No new model present in ValidatedResult"));
            this.newModelEvents = newModel.getValidationEvents();
            return this;
        }

        public Result compare() {
            return this.compare(Differences.detect(this.oldModel, this.newModel));
        }

        public Result compare(Differences differences) {
            SmithyBuilder.requiredState((String)"oldModel", (Object)this.oldModel);
            SmithyBuilder.requiredState((String)"newModel", (Object)this.newModel);
            ArrayList evaluators = new ArrayList();
            ServiceLoader.load(DiffEvaluator.class, this.classLoader).forEach(evaluators::add);
            ValidationEventDecorator decoratorResult = new ModelBasedEventDecorator().createDecorator(this.newModel).getResult().orElse(ValidationEventDecorator.IDENTITY);
            List<ValidationEvent> diffEvents = evaluators.parallelStream().flatMap(evaluator -> evaluator.evaluate(differences).stream()).map(arg_0 -> ((ValidationEventDecorator)decoratorResult).decorate(arg_0)).collect(Collectors.toList());
            return new Result(differences, diffEvents, this.oldModelEvents, this.newModelEvents);
        }
    }

    public static final class Result {
        private final Differences differences;
        private final List<ValidationEvent> diffEvents;
        private final List<ValidationEvent> oldModelEvents;
        private final List<ValidationEvent> newModelEvents;

        public Result(Differences differences, List<ValidationEvent> diffEvents, List<ValidationEvent> oldModelEvents, List<ValidationEvent> newModelEvents) {
            this.differences = Objects.requireNonNull(differences);
            this.diffEvents = Objects.requireNonNull(diffEvents);
            this.oldModelEvents = Objects.requireNonNull(oldModelEvents);
            this.newModelEvents = Objects.requireNonNull(newModelEvents);
        }

        public Differences getDifferences() {
            return this.differences;
        }

        public List<ValidationEvent> getDiffEvents() {
            return this.diffEvents;
        }

        public List<ValidationEvent> getOldModelEvents() {
            return this.oldModelEvents;
        }

        public List<ValidationEvent> getNewModelEvents() {
            return this.newModelEvents;
        }

        public Set<ValidationEvent> determineResolvedEvents() {
            TreeSet<ValidationEvent> events = new TreeSet<ValidationEvent>(this.getOldModelEvents());
            this.getNewModelEvents().forEach(events::remove);
            return events;
        }

        public Set<ValidationEvent> determineIntroducedEvents() {
            TreeSet<ValidationEvent> events = new TreeSet<ValidationEvent>(this.getNewModelEvents());
            this.getOldModelEvents().forEach(events::remove);
            return events;
        }

        public boolean isDiffBreaking() {
            for (ValidationEvent event : this.getDiffEvents()) {
                if (event.getSeverity() != Severity.ERROR && event.getSeverity() != Severity.DANGER) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result result = (Result)o;
            return this.getDifferences().equals(result.getDifferences()) && this.getDiffEvents().equals(result.getDiffEvents()) && this.getOldModelEvents().equals(result.getOldModelEvents()) && this.getNewModelEvents().equals(result.getNewModelEvents());
        }

        public int hashCode() {
            return Objects.hash(this.getDifferences(), this.getDiffEvents(), this.getOldModelEvents(), this.getNewModelEvents());
        }
    }
}

