/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.Pair;

public final class ChangedShape<S extends Shape>
implements FromSourceLocation {
    private final S oldShape;
    private final S newShape;
    private final Map<ShapeId, Pair<Trait, Trait>> traitDiff;

    public ChangedShape(S oldShape, S newShape) {
        this.oldShape = oldShape;
        this.newShape = newShape;
        this.traitDiff = Collections.unmodifiableMap(ChangedShape.findTraitDifferences(oldShape, newShape));
    }

    public S getOldShape() {
        return this.oldShape;
    }

    public S getNewShape() {
        return this.newShape;
    }

    public SourceLocation getSourceLocation() {
        return this.getNewShape().getSourceLocation();
    }

    public ShapeId getShapeId() {
        return this.newShape.getId();
    }

    public Stream<Trait> addedTraits() {
        return this.traitDiff.values().stream().filter(pair -> pair.getLeft() == null).map(Pair::getRight);
    }

    public Stream<Trait> removedTraits() {
        return this.traitDiff.values().stream().filter(pair -> pair.getRight() == null).map(Pair::getLeft);
    }

    public Stream<Pair<Trait, Trait>> changedTraits() {
        return this.traitDiff.values().stream().filter(pair -> pair.getLeft() != null && pair.getRight() != null);
    }

    public <T extends Trait> Optional<Pair<T, T>> getChangedTrait(Class<T> traitType) {
        return this.changedTraits().filter(p -> traitType.isInstance(p.getLeft()) && traitType.isInstance(p.getRight())).map(p -> p).findFirst();
    }

    public Map<ShapeId, Pair<Trait, Trait>> getTraitDifferences() {
        return this.traitDiff;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangedShape)) {
            return false;
        }
        ChangedShape that = (ChangedShape)o;
        return Objects.equals(this.getOldShape(), that.getOldShape()) && Objects.equals(this.getNewShape(), that.getNewShape());
    }

    public int hashCode() {
        return Objects.hash(this.getOldShape(), this.getNewShape());
    }

    private static Map<ShapeId, Pair<Trait, Trait>> findTraitDifferences(Shape oldShape, Shape newShape) {
        HashMap<ShapeId, Pair<Trait, Trait>> changes = new HashMap<ShapeId, Pair<Trait, Trait>>();
        for (Trait oldTrait : oldShape.getAllTraits().values()) {
            Trait newTrait2 = newShape.findTrait(oldTrait.toShapeId()).orElse(null);
            if (newTrait2 == null) {
                changes.put(oldTrait.toShapeId(), (Pair<Trait, Trait>)Pair.of((Object)oldTrait, null));
                continue;
            }
            if (newTrait2.equals(oldTrait)) continue;
            changes.put(newTrait2.toShapeId(), (Pair<Trait, Trait>)Pair.of((Object)oldTrait, (Object)newTrait2));
        }
        newShape.getAllTraits().values().stream().filter(newTrait -> !oldShape.findTrait(newTrait.toShapeId()).isPresent()).forEach(newTrait -> changes.put(newTrait.toShapeId(), Pair.of(null, (Object)newTrait)));
        return changes;
    }
}

