/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

public class ChangedNullability
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        NullableIndex oldIndex = NullableIndex.of((Model)differences.getOldModel());
        NullableIndex newIndex = NullableIndex.of((Model)differences.getNewModel());
        HashSet events = new HashSet();
        Stream.concat(differences.changedShapes(MemberShape.class), this.changedInputMembers(differences)).forEach(change -> {
            boolean isNowNullable;
            MemberShape oldShape = (MemberShape)change.getOldShape();
            MemberShape newShape = (MemberShape)change.getNewShape();
            boolean wasNullable = oldIndex.isMemberNullable(oldShape);
            if (wasNullable != (isNowNullable = newIndex.isMemberNullable(newShape))) {
                this.createErrors(differences, (ChangedShape<MemberShape>)change, wasNullable, events);
            }
        });
        return new ArrayList<ValidationEvent>(events);
    }

    private Stream<ChangedShape<MemberShape>> changedInputMembers(Differences differences) {
        return differences.changedShapes(StructureShape.class).filter(change -> change.isTraitAdded(InputTrait.ID) || change.isTraitRemoved(InputTrait.ID)).flatMap(change -> ((StructureShape)change.getNewShape()).members().stream().map(newMember -> {
            MemberShape old = (MemberShape)((StructureShape)change.getOldShape()).getAllMembers().get(newMember.getMemberName());
            return old == null ? null : new ChangedShape<MemberShape>(old, (MemberShape)newMember);
        }).filter(Objects::nonNull));
    }

    private void createErrors(Differences differences, ChangedShape<MemberShape> change, boolean wasNullable, Collection<ValidationEvent> events) {
        MemberShape oldMember = change.getOldShape();
        MemberShape newMember = change.getNewShape();
        String message = String.format("Member `%s` changed from %s to %s: ", oldMember.getMemberName(), wasNullable ? "nullable" : "non-nullable", wasNullable ? "non-nullable" : "nullable");
        boolean oldHasInput = this.hasInputTrait(differences.getOldModel(), oldMember);
        boolean newHasInput = this.hasInputTrait(differences.getNewModel(), newMember);
        ShapeId shape = change.getShapeId();
        Shape newTarget = differences.getNewModel().expectShape(newMember.getTarget());
        ArrayList<ValidationEvent> eventsToAdd = new ArrayList<ValidationEvent>();
        if (oldHasInput && !newHasInput) {
            eventsToAdd.add(this.emit(Severity.ERROR, "RemovedInputTrait", shape, message, "The @input trait was removed from " + newMember.getContainer()));
        } else if (!oldHasInput && newHasInput) {
            eventsToAdd.add(this.emit(Severity.DANGER, "AddedInputTrait", shape, message, "The @input trait was added to " + newMember.getContainer()));
        } else if (!newHasInput) {
            if (change.isTraitAdded(ClientOptionalTrait.ID) && change.isTraitInBoth(RequiredTrait.ID)) {
                eventsToAdd.add(this.emit(Severity.ERROR, "AddedClientOptionalTrait", shape, message, "The @clientOptional trait was added to a @required member."));
            }
            if (change.isTraitAdded(RequiredTrait.ID) && !newMember.hasTrait(ClientOptionalTrait.ID)) {
                eventsToAdd.add(this.emit(Severity.ERROR, "AddedRequiredTrait", shape, message, "The @required trait was added to a member."));
            }
            if (change.isTraitAdded(DefaultTrait.ID) && !change.isTraitRemoved(RequiredTrait.ID)) {
                eventsToAdd.add(this.emit(Severity.ERROR, "AddedDefaultTrait", shape, message, "The @default trait was added to a member that was not previously @required."));
            }
            if (change.isTraitRemoved(RequiredTrait.ID) && !newMember.hasTrait(DefaultTrait.ID) && !oldMember.hasTrait(ClientOptionalTrait.ID)) {
                if (newTarget.isStructureShape() || newTarget.isUnionShape()) {
                    eventsToAdd.add(this.emit(Severity.WARNING, "RemovedRequiredTrait.StructureOrUnion", shape, message, "The @required trait was removed from a member that targets a " + newTarget.getType() + ". This is backward compatible in generators that always treat structures and unions as optional (e.g., AWS generators)"));
                } else {
                    eventsToAdd.add(this.emit(Severity.ERROR, "RemovedRequiredTrait", shape, message, "The @required trait was removed and not replaced with the @default trait and @addedDefault trait."));
                }
            }
        }
        if (eventsToAdd.isEmpty()) {
            eventsToAdd.add(this.emit(Severity.ERROR, null, shape, null, message));
        }
        events.addAll(eventsToAdd);
    }

    private boolean hasInputTrait(Model model, MemberShape member) {
        return model.getShape(member.getContainer()).filter(shape -> shape.hasTrait(InputTrait.ID)).isPresent();
    }

    private ValidationEvent emit(Severity severity, String eventIdSuffix, ShapeId shape, String prefixMessage, String message) {
        String actualId = eventIdSuffix == null ? this.getEventId() : this.getEventId() + '.' + eventIdSuffix;
        String actualMessage = prefixMessage == null ? message : prefixMessage + "; " + message;
        return ValidationEvent.builder().id(actualId).shapeId((ToShapeId)shape).message(actualMessage).severity(severity).build();
    }
}

