/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff;

import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;

public final class ChangedMetadata
implements FromSourceLocation {
    private final String key;
    private final Node oldValue;
    private final Node newValue;

    ChangedMetadata(String key, Node oldValue, Node newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getKey() {
        return this.key;
    }

    public Node getOldValue() {
        return this.oldValue;
    }

    public Node getNewValue() {
        return this.newValue;
    }

    public SourceLocation getSourceLocation() {
        return this.getNewValue().getSourceLocation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangedMetadata)) {
            return false;
        }
        ChangedMetadata that = (ChangedMetadata)o;
        return this.getKey().equals(that.getKey()) && Objects.equals(this.getOldValue(), that.getOldValue()) && Objects.equals(this.getNewValue(), that.getNewValue());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getOldValue(), this.getNewValue());
    }
}

