/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ChangedMemberOrder
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        Stream<ChangedShape<UnionShape>> changes = Stream.concat(differences.changedShapes(StructureShape.class), differences.changedShapes(UnionShape.class));
        return changes.filter(diff -> ChangedMemberOrder.isUnordered(diff.getOldShape().members(), diff.getNewShape().members())).map(diff -> this.danger((Shape)diff.getNewShape(), String.format("%s shape members were reordered. This can cause ABI compatibility issues in languages like C and C++ where the layout and alignment of a data structure matters.", diff.getOldShape().getType()))).collect(Collectors.toList());
    }

    private static boolean isUnordered(Collection<MemberShape> a, Collection<MemberShape> b) {
        Iterator<MemberShape> aIter = a.iterator();
        Iterator<MemberShape> bIter = b.iterator();
        while (aIter.hasNext() && bIter.hasNext()) {
            String newMember;
            String oldMember = aIter.next().getMemberName();
            if (oldMember.equals(newMember = bIter.next().getMemberName())) continue;
            return true;
        }
        return false;
    }
}

