/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.InputTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.ValidationEvent;

public class ChangedNullability
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        NullableIndex oldIndex = NullableIndex.of((Model)differences.getOldModel());
        NullableIndex newIndex = NullableIndex.of((Model)differences.getNewModel());
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Stream<ChangedShape<MemberShape>> changed = Stream.concat(differences.changedShapes(MemberShape.class), this.changedInputMembers(differences));
        changed.map(change -> {
            boolean isNowNullable;
            MemberShape oldShape = (MemberShape)change.getOldShape();
            MemberShape newShape = (MemberShape)change.getNewShape();
            boolean wasNullable = oldIndex.isMemberNullable(oldShape);
            return wasNullable == (isNowNullable = newIndex.isMemberNullable(newShape)) ? null : this.createError(differences, (ChangedShape<MemberShape>)change, wasNullable);
        }).filter(Objects::nonNull).forEach(events::add);
        return events;
    }

    private Stream<ChangedShape<MemberShape>> changedInputMembers(Differences differences) {
        return differences.changedShapes(StructureShape.class).filter(change -> change.isTraitAdded(InputTrait.ID) || change.isTraitRemoved(InputTrait.ID)).flatMap(change -> ((StructureShape)change.getNewShape()).members().stream().map(newMember -> {
            MemberShape old = (MemberShape)((StructureShape)change.getOldShape()).getAllMembers().get(newMember.getMemberName());
            return old == null ? null : new ChangedShape<MemberShape>(old, (MemberShape)newMember);
        }).filter(Objects::nonNull));
    }

    private ValidationEvent createError(Differences differences, ChangedShape<MemberShape> change, boolean wasNullable) {
        MemberShape oldMember = change.getOldShape();
        MemberShape newMember = change.getNewShape();
        String message = String.format("Member `%s` changed from %s to %s: ", oldMember.getMemberName(), wasNullable ? "nullable" : "non-nullable", wasNullable ? "non-nullable" : "nullable");
        StringJoiner joiner = new StringJoiner("; ", message, "");
        boolean oldHasInput = this.hasInputTrait(differences.getOldModel(), oldMember);
        boolean newHasInput = this.hasInputTrait(differences.getNewModel(), newMember);
        if (oldHasInput && !newHasInput) {
            joiner.add("The @input trait was removed from " + newMember.getContainer());
        } else if (!oldHasInput && newHasInput) {
            joiner.add("The @input trait was added to " + newMember.getContainer());
        } else if (!newHasInput) {
            if (change.isTraitAdded(ClientOptionalTrait.ID) && change.isTraitInBoth(RequiredTrait.ID)) {
                joiner.add("The @nullable trait was added to a @required member.");
            }
            if (change.isTraitAdded(RequiredTrait.ID) && !newMember.hasTrait(ClientOptionalTrait.ID)) {
                joiner.add("The @required trait was added to a member that is not marked as @nullable.");
            }
            if (change.isTraitAdded(DefaultTrait.ID) && !change.isTraitRemoved(RequiredTrait.ID)) {
                joiner.add("The @default trait was added to a member that was not previously @required.");
            }
            if (change.isTraitRemoved(RequiredTrait.ID) && !newMember.hasTrait(DefaultTrait.ID) && !oldMember.hasTrait(ClientOptionalTrait.ID)) {
                joiner.add("The @required trait was removed and not replaced with the @default trait.");
            }
        }
        return this.error((Shape)change.getNewShape(), joiner.toString());
    }

    private boolean hasInputTrait(Model model, MemberShape member) {
        return model.getShape(member.getContainer()).filter(shape -> shape.hasTrait(InputTrait.ID)).isPresent();
    }
}

