/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.DiffEvaluator;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ModelDiff {
    private ModelDiff() {
    }

    public static List<ValidationEvent> compare(Model oldModel, Model newModel) {
        return ModelDiff.compare(ModelDiff.class.getClassLoader(), oldModel, newModel);
    }

    public static List<ValidationEvent> compare(ClassLoader classLoader, Model oldModel, Model newModel) {
        ArrayList<DiffEvaluator> evaluators = new ArrayList<DiffEvaluator>();
        ServiceLoader.load(DiffEvaluator.class, classLoader).forEach(evaluators::add);
        return ModelDiff.compare(evaluators, oldModel, newModel);
    }

    private static List<ValidationEvent> compare(List<DiffEvaluator> evaluators, Model oldModel, Model newModel) {
        Differences differences = Differences.detect(oldModel, newModel);
        return evaluators.parallelStream().flatMap(evaluator -> evaluator.evaluate(differences).stream()).collect(Collectors.toList());
    }
}

